/*
 * Decompiled with CFR 0.152.
 */
package com.google.thirdparty.jodatime;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.time.Clock;
import com.google.common.time.TimeSource;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public final class JavaTimeConversions {
    private JavaTimeConversions() {
    }

    public static org.joda.time.Instant toJodaInstant(Instant instant) {
        return new org.joda.time.Instant(instant.toEpochMilli());
    }

    public static Instant toJavaInstant(ReadableInstant instant) {
        return Instant.ofEpochMilli(instant.getMillis());
    }

    public static Duration toJodaDuration(java.time.Duration duration) {
        return Duration.millis(duration.toMillis());
    }

    public static java.time.Duration toJavaDuration(ReadableDuration duration) {
        return java.time.Duration.ofMillis(duration.getMillis());
    }

    public static DateTimeZone toJodaDateTimeZone(ZoneId zoneId) {
        return DateTimeZone.forID(zoneId.getId());
    }

    public static ZoneId toJavaZoneId(DateTimeZone dateTimeZone) {
        return ZoneId.of(dateTimeZone.getID());
    }

    public static org.joda.time.LocalDate toJodaLocalDate(LocalDate date) {
        return new org.joda.time.LocalDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    public static LocalDate toJavaLocalDate(org.joda.time.LocalDate date) {
        return LocalDate.of(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth());
    }

    public static TimeSource asTimeSource(Clock clock) {
        Preconditions.checkNotNull(clock);
        return () -> JavaTimeConversions.toJavaInstant(clock.now());
    }

    public static Clock asJodaClock(TimeSource timeSource) {
        return new TimeSourceBackedJodaClock(timeSource);
    }

    @GwtCompatible(serializable=true)
    private static final class TimeSourceBackedJodaClock
    implements Clock,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final TimeSource timeSource;

        private TimeSourceBackedJodaClock(TimeSource timeSource) {
            this.timeSource = Preconditions.checkNotNull(timeSource);
        }

        @Override
        public org.joda.time.Instant now() {
            return JavaTimeConversions.toJodaInstant(this.timeSource.now());
        }

        public int hashCode() {
            return this.timeSource.hashCode();
        }

        public boolean equals(@NullableDecl Object other) {
            if (other instanceof TimeSourceBackedJodaClock) {
                TimeSourceBackedJodaClock that = (TimeSourceBackedJodaClock)other;
                return this.timeSource.equals(that.timeSource);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("timeSource", this.timeSource).toString();
        }
    }
}

