/*
 * Decompiled with CFR 0.152.
 */
package com.google.thirdparty.jodatime;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadablePartial;

@Deprecated
@GwtCompatible(emulated=true)
public enum JodaDayOfWeek {
    SATURDAY(6),
    SUNDAY(7),
    MONDAY(1),
    TUESDAY(2),
    WEDNESDAY(3),
    THURSDAY(4),
    FRIDAY(5);

    private final int jodaConstant;
    private static final ImmutableList<JodaDayOfWeek> VALUES;

    private JodaDayOfWeek(int jodaConstant) {
        this.jodaConstant = jodaConstant;
    }

    @Deprecated
    public int toJoda() {
        return this.jodaConstant;
    }

    @Deprecated
    public static JodaDayOfWeek fromJoda(int jodaConstant) {
        switch (jodaConstant) {
            case 1: {
                return MONDAY;
            }
            case 2: {
                return TUESDAY;
            }
            case 3: {
                return WEDNESDAY;
            }
            case 4: {
                return THURSDAY;
            }
            case 5: {
                return FRIDAY;
            }
            case 6: {
                return SATURDAY;
            }
            case 7: {
                return SUNDAY;
            }
        }
        throw new IllegalArgumentException(new StringBuilder(51).append("invalid Joda-Time day-of-week constant: ").append(jodaConstant).toString());
    }

    @Deprecated
    public static JodaDayOfWeek fromCalendarConstant(int calendarConstant) {
        if (calendarConstant >= 1 && calendarConstant <= 7) {
            return JodaDayOfWeek.fromJoda(calendarConstant > 1 ? calendarConstant - 1 : 7);
        }
        throw new IllegalArgumentException(new StringBuilder(50).append("invalid Calendar day-of-week constant: ").append(calendarConstant).toString());
    }

    @GwtIncompatible(value="ReadableDateTime")
    public static JodaDayOfWeek of(ReadableDateTime dateTime) {
        return JodaDayOfWeek.fromJoda(dateTime.getDayOfWeek());
    }

    @GwtIncompatible(value="ReadablePartial.get()")
    public static JodaDayOfWeek of(ReadablePartial date) {
        return JodaDayOfWeek.fromJoda(date.get(DateTimeFieldType.dayOfWeek()));
    }

    public static ImmutableList<JodaDayOfWeek> values(JodaDayOfWeek startWith) {
        Preconditions.checkNotNull(startWith);
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)VALUES.subList(startWith.ordinal(), VALUES.size()))).addAll((Iterable)VALUES.subList(0, startWith.ordinal()))).build();
    }

    @Deprecated
    public JodaDayOfWeek plusDays(int days) {
        return (JodaDayOfWeek)((Object)VALUES.get(JodaDayOfWeek.mod7((long)this.ordinal() + (long)days)));
    }

    @Deprecated
    public JodaDayOfWeek minusDays(int days) {
        return (JodaDayOfWeek)((Object)VALUES.get(JodaDayOfWeek.mod7((long)this.ordinal() - (long)days)));
    }

    private static int mod7(long a) {
        int result = (int)(a % 7L);
        return result < 0 ? result + 7 : result;
    }

    public int daysUntil(JodaDayOfWeek other) {
        Preconditions.checkNotNull(other);
        return JodaDayOfWeek.mod7(other.ordinal() - this.ordinal());
    }

    static {
        VALUES = ImmutableList.copyOf(JodaDayOfWeek.values());
    }
}

