/*
 * Decompiled with CFR 0.152.
 */
package com.google.thirdparty.jodatime;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.BoundType;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Sets;
import com.google.common.math.LongMath;
import com.google.errorprone.annotations.DoNotCall;
import com.google.thirdparty.jodatime.JodaDayOfWeek;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

@GwtCompatible(emulated=true)
public final class JodaTime {
    @GwtIncompatible
    private static final Advancer<DateTime, Period> DATE_TIME_ADVANCER = new Advancer<DateTime, Period>(){

        @Override
        public DateTime advance(DateTime date, int count, Period step) {
            return date.withPeriodAdded(step, count);
        }
    };
    @GwtIncompatible
    private static final Advancer<Instant, Duration> INSTANT_ADVANCER = new Advancer<Instant, Duration>(){

        @Override
        public Instant advance(Instant date, int count, Duration step) {
            return date.withDurationAdded(step, count);
        }
    };
    @GwtIncompatible
    private static final Advancer<LocalDate, Period> LOCAL_DATE_ADVANCER = new Advancer<LocalDate, Period>(){

        @Override
        public LocalDate advance(LocalDate date, int count, Period step) {
            return date.withPeriodAdded(step, count);
        }
    };
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MICROS_PER_MILLI = 1000L;

    public static Duration checkNotNegative(Duration duration) {
        Preconditions.checkArgument(duration.getMillis() >= 0L, "duration (%s) must not be negative", (Object)duration);
        return duration;
    }

    public static Duration checkPositive(Duration duration) {
        Preconditions.checkArgument(duration.getMillis() > 0L, "duration (%s) must be positive", (Object)duration);
        return duration;
    }

    public static double toSecondsAsDouble(ReadableDuration duration) {
        return (double)duration.getMillis() / 1000.0;
    }

    public static Duration ofMicros(long micros) {
        return Duration.millis(micros / 1000L);
    }

    public static Duration ofSeconds(double seconds) {
        return Duration.millis((long)(seconds * 1000.0));
    }

    @Deprecated
    @DoNotCall(value="Use Duration.standardSeconds(long) instead")
    public static Duration ofSeconds(long seconds) {
        return Duration.standardSeconds(seconds);
    }

    public static long toMicros(ReadableDuration duration) {
        return LongMath.checkedMultiply(duration.getMillis(), 1000L);
    }

    public static Instant ofEpochMicros(long micros) {
        return new Instant(micros / 1000L);
    }

    public static Instant ofEpochSeconds(long seconds) {
        return new Instant(LongMath.checkedMultiply(seconds, 1000L));
    }

    public static long toEpochMicros(ReadableInstant instant) {
        return LongMath.checkedMultiply(instant.getMillis(), 1000L);
    }

    public static long toEpochSeconds(ReadableInstant instant) {
        return instant.getMillis() / 1000L;
    }

    @GwtIncompatible
    public static DateTimeZone googleTimeZone() {
        return GoogleTimeZoneHolder.GOOGLE_TIME_ZONE;
    }

    @GwtIncompatible
    public static Timestamp toTimestamp(ReadableInstant instant) {
        return new Timestamp(instant.getMillis());
    }

    @GwtIncompatible
    public static DateTime startOfMonth(ReadableDateTime dateTime) {
        return dateTime.toDateTime().monthOfYear().roundFloorCopy();
    }

    public static DiscreteDomain<Instant> instantDomain() {
        return InstantDomain.INSTANCE;
    }

    @GwtIncompatible
    public static DiscreteDomain<LocalDate> localDateDomain() {
        return LocalDateDomain.INSTANCE;
    }

    @GwtIncompatible
    public static Iterable<DateTime> dateIterable(ReadableDateTime from, ReadableDateTime to, ReadablePeriod step, BoundType boundType) {
        return new JodaDateIterable<DateTime, Period>(from.toDateTime(), to.toDateTime(), step.toPeriod(), DATE_TIME_ADVANCER, boundType);
    }

    @GwtIncompatible
    public static Iterable<Instant> dateIterable(ReadableInstant from, ReadableInstant to, ReadableDuration step, BoundType boundType) {
        return new JodaDateIterable<Instant, Duration>(from.toInstant(), to.toInstant(), step.toDuration(), INSTANT_ADVANCER, boundType);
    }

    @GwtIncompatible
    public static Iterable<LocalDate> dateIterable(LocalDate from, LocalDate to, ReadablePeriod step, BoundType boundType) {
        return new JodaDateIterable<LocalDate, Period>(from, to, step.toPeriod(), LOCAL_DATE_ADVANCER, boundType);
    }

    @GwtIncompatible
    public static LocalDate plusDays(LocalDate start, int n, JodaDayOfWeek skipDay, JodaDayOfWeek ... otherSkipDays) {
        return JodaTime.plusDays(start, n, Sets.immutableEnumSet((Enum)skipDay, (Enum[])otherSkipDays));
    }

    @GwtIncompatible
    public static LocalDate plusDays(LocalDate start, int n, Set<JodaDayOfWeek> skipSet) {
        int skipSize = skipSet.size();
        Preconditions.checkArgument(skipSize < 7, "Must count at least one day of week");
        Preconditions.checkNotNull(start);
        if (n == 0) {
            return start;
        }
        LocalDate result = start;
        int unskippedDaysPerWeek = 7 - skipSize;
        int increment = Integer.signum(n);
        int weeks = n / unskippedDaysPerWeek;
        result = result.plusWeeks(weeks);
        n -= unskippedDaysPerWeek * weeks;
        while (n != 0) {
            JodaDayOfWeek dayOfWeek = JodaDayOfWeek.of(result = result.plusDays(increment));
            if (skipSet.contains((Object)dayOfWeek)) continue;
            n -= increment;
        }
        return result;
    }

    private JodaTime() {
    }

    @GwtIncompatible
    private static class JodaDateIterable<D extends Comparable<? super D>, S>
    implements Iterable<D> {
        final D from;
        final D to;
        final S step;
        final Advancer<D, S> advancer;
        final BoundType boundType;

        JodaDateIterable(D from, D to, S step, Advancer<D, S> advancer, BoundType boundType) {
            this.from = (Comparable)Preconditions.checkNotNull(from);
            this.to = (Comparable)Preconditions.checkNotNull(to);
            this.step = Preconditions.checkNotNull(step);
            this.advancer = Preconditions.checkNotNull(advancer);
            this.boundType = Preconditions.checkNotNull(boundType);
        }

        @Override
        public Iterator<D> iterator() {
            return new AbstractIterator<D>(){
                int index = 0;

                @Override
                protected D computeNext() {
                    Comparable candidate = (Comparable)advancer.advance(from, this.index, step);
                    ++this.index;
                    int cmp = candidate.compareTo(to);
                    return JodaDateIterable.shouldContinue(boundType, cmp) ? candidate : (Comparable)this.endOfData();
                }
            };
        }

        public String toString() {
            return String.format("{%s%s, %s%s, every %s}", "[", this.from, this.to, JodaDateIterable.getClosingBracket(this.boundType), this.step);
        }

        private static String getClosingBracket(BoundType boundType) {
            return boundType == BoundType.OPEN ? ")" : "]";
        }

        private static boolean shouldContinue(BoundType boundType, int compareToResult) {
            return boundType == BoundType.OPEN ? compareToResult < 0 : compareToResult <= 0;
        }
    }

    @GwtIncompatible
    private static interface Advancer<D, S> {
        public D advance(D var1, int var2, S var3);
    }

    @GwtIncompatible
    private static class LocalDateDomain
    extends DiscreteDomain<LocalDate> {
        static final LocalDateDomain INSTANCE = new LocalDateDomain();

        private LocalDateDomain() {
        }

        @Override
        public long distance(LocalDate start, LocalDate end) {
            return Days.daysBetween(start, end).getDays();
        }

        @Override
        public LocalDate next(LocalDate value) {
            return value.plusDays(1);
        }

        @Override
        public LocalDate previous(LocalDate value) {
            return value.minusDays(1);
        }
    }

    private static class InstantDomain
    extends DiscreteDomain<Instant> {
        static final InstantDomain INSTANCE = new InstantDomain();

        private InstantDomain() {
        }

        @Override
        public long distance(Instant start, Instant end) {
            return new Interval((ReadableInstant)start, (ReadableInstant)end).toDurationMillis();
        }

        @Override
        public Instant next(Instant instant) {
            return instant.plus(Duration.millis(1L));
        }

        @Override
        public Instant previous(Instant instant) {
            return instant.minus(Duration.millis(1L));
        }
    }

    @GwtIncompatible
    private static final class GoogleTimeZoneHolder {
        static final DateTimeZone GOOGLE_TIME_ZONE = DateTimeZone.forID("America/Los_Angeles");

        private GoogleTimeZoneHolder() {
        }
    }
}

