/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.text.UCharacterIterator;

public final class UCharArrayIterator
extends UCharacterIterator {
    private final char[] text;
    private final int start;
    private final int limit;
    private int pos;

    public UCharArrayIterator(char[] text, int start, int limit) {
        if (start < 0 || limit > text.length || start > limit) {
            int n = text.length;
            throw new IllegalArgumentException(new StringBuilder(70).append("start: ").append(start).append(" or limit: ").append(limit).append(" out of range [0, ").append(n).append(")").toString());
        }
        this.text = text;
        this.start = start;
        this.limit = limit;
        this.pos = start;
    }

    @Override
    public int current() {
        return this.pos < this.limit ? this.text[this.pos] : -1;
    }

    @Override
    public int getLength() {
        return this.limit - this.start;
    }

    @Override
    public int getIndex() {
        return this.pos - this.start;
    }

    @Override
    public int next() {
        return this.pos < this.limit ? this.text[this.pos++] : -1;
    }

    @Override
    public int previous() {
        return this.pos > this.start ? this.text[--this.pos] : -1;
    }

    @Override
    public void setIndex(int index) {
        if (index < 0 || index > this.limit - this.start) {
            int n = this.limit - this.start;
            throw new IndexOutOfBoundsException(new StringBuilder(48).append("index: ").append(index).append(" out of range [0, ").append(n).append(")").toString());
        }
        this.pos = this.start + index;
    }

    @Override
    public int getText(char[] fillIn, int offset) {
        int len = this.limit - this.start;
        System.arraycopy(this.text, this.start, fillIn, offset, len);
        return len;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

