/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.data;

import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.PatternProps;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class ResourceReader
implements Closeable {
    private BufferedReader reader;
    private String resourceName;
    private String encoding;
    private Class<?> root;
    private int lineNo;

    public ResourceReader(String resourceName, String encoding) throws UnsupportedEncodingException {
        String string = String.valueOf(resourceName);
        this(ICUData.class, string.length() != 0 ? "data/".concat(string) : new String("data/"), encoding);
    }

    public ResourceReader(String resourceName) {
        String string = String.valueOf(resourceName);
        this(ICUData.class, string.length() != 0 ? "data/".concat(string) : new String("data/"));
    }

    public ResourceReader(Class<?> rootClass, String resourceName, String encoding) throws UnsupportedEncodingException {
        this.reader = null;
        this.root = rootClass;
        this.resourceName = resourceName;
        this.encoding = encoding;
        this.lineNo = -1;
        this._reset();
    }

    public ResourceReader(InputStream is, String resourceName, String encoding) {
        this.reader = null;
        this.root = null;
        this.resourceName = resourceName;
        this.encoding = encoding;
        this.lineNo = -1;
        try {
            InputStreamReader isr = encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, encoding);
            this.reader = new BufferedReader(isr);
            this.lineNo = 0;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public ResourceReader(InputStream is, String resourceName) {
        this(is, resourceName, null);
    }

    public ResourceReader(Class<?> rootClass, String resourceName) {
        this.reader = null;
        this.root = rootClass;
        this.resourceName = resourceName;
        this.encoding = null;
        this.lineNo = -1;
        try {
            this._reset();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String readLine() throws IOException {
        if (this.lineNo == 0) {
            ++this.lineNo;
            String line = this.reader.readLine();
            if (line != null && (line.charAt(0) == '\uffef' || line.charAt(0) == '\ufeff')) {
                line = line.substring(1);
            }
            return line;
        }
        ++this.lineNo;
        return this.reader.readLine();
    }

    public String readLineSkippingComments(boolean trim) throws IOException {
        String line;
        int pos;
        do {
            if ((line = this.readLine()) != null) continue;
            return line;
        } while ((pos = PatternProps.skipWhiteSpace(line, 0)) == line.length() || line.charAt(pos) == '#');
        if (trim) {
            line = line.substring(pos);
        }
        return line;
    }

    public String readLineSkippingComments() throws IOException {
        return this.readLineSkippingComments(false);
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public String describePosition() {
        String string = this.resourceName;
        int n = this.lineNo;
        return new StringBuilder(12 + String.valueOf(string).length()).append(string).append(':').append(n).toString();
    }

    public void reset() {
        try {
            this._reset();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void _reset() throws UnsupportedEncodingException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.lineNo == 0) {
            return;
        }
        InputStream is = ICUData.getStream(this.root, this.resourceName);
        if (is == null) {
            String string = String.valueOf(this.resourceName);
            throw new IllegalArgumentException(string.length() != 0 ? "Can't open ".concat(string) : new String("Can't open "));
        }
        InputStreamReader isr = this.encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.encoding);
        this.reader = new BufferedReader(isr);
        this.lineNo = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }
}

