/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.UResource;
import com.ibm.icu.impl.locale.LSR;
import com.ibm.icu.impl.locale.XCldrStub;
import com.ibm.icu.impl.locale.XLikelySubtags;
import com.ibm.icu.util.BytesTrie;
import com.ibm.icu.util.BytesTrieBuilder;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.StringTrieBuilder;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class LikelySubtagsBuilder {
    private static final boolean DEBUG_OUTPUT = false;

    LikelySubtagsBuilder() {
    }

    private static ICUResourceBundle getSupplementalDataBundle(String name) {
        return ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt64b", name, ICUResourceBundle.ICU_DATA_CLASS_LOADER, ICUResourceBundle.OpenType.DIRECT);
    }

    static XLikelySubtags.Data build() {
        AliasesBuilder languageAliasesBuilder = new AliasesBuilder("language");
        AliasesBuilder regionAliasesBuilder = new AliasesBuilder("territory");
        Map<String, Map<String, Map<String, LSR>>> langTable = LikelySubtagsBuilder.makeTable(languageAliasesBuilder, regionAliasesBuilder);
        TrieBuilder trieBuilder = new TrieBuilder();
        LinkedHashMap<LSR, Integer> lsrIndexes = new LinkedHashMap<LSR, Integer>();
        LSR bogus = new LSR("", "", "");
        lsrIndexes.put(bogus, 0);
        for (Map.Entry<String, Map<String, Map<String, LSR>>> ls : langTable.entrySet()) {
            String lang = ls.getKey();
            if (lang.equals("und")) {
                lang = "*";
            }
            trieBuilder.addMapping(lang, 0);
            Map<String, Map<String, LSR>> scriptTable = ls.getValue();
            for (Map.Entry<String, Map<String, LSR>> sr : scriptTable.entrySet()) {
                String script = sr.getKey();
                if (script.isEmpty()) {
                    script = "*";
                }
                String string = String.valueOf(lang);
                String string2 = String.valueOf(script);
                trieBuilder.addMapping(string2.length() != 0 ? string.concat(string2) : new String(string), 0);
                Map<String, LSR> regionTable = sr.getValue();
                for (Map.Entry<String, LSR> r2lsr : regionTable.entrySet()) {
                    int i;
                    LSR lsr;
                    Integer index;
                    String region = r2lsr.getKey();
                    if (region.isEmpty()) {
                        region = "*";
                    }
                    if ((index = (Integer)lsrIndexes.get(lsr = r2lsr.getValue())) != null) {
                        i = index;
                    } else {
                        i = lsrIndexes.size();
                        lsrIndexes.put(lsr, i);
                    }
                    String string3 = lang;
                    String string4 = script;
                    String string5 = region;
                    trieBuilder.addMapping(new StringBuilder(String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string3).append(string4).append(string5).toString(), i);
                }
            }
        }
        BytesTrie trie = trieBuilder.build();
        LSR[] lsrs = lsrIndexes.keySet().toArray(new LSR[lsrIndexes.size()]);
        return new XLikelySubtags.Data(languageAliasesBuilder.toCanonical, regionAliasesBuilder.toCanonical, trie, lsrs);
    }

    private static Map<String, Map<String, Map<String, LSR>>> makeTable(AliasesBuilder languageAliasesBuilder, AliasesBuilder regionAliasesBuilder) {
        TreeMap<String, Map<String, Map<String, LSR>>> result = new TreeMap<String, Map<String, Map<String, LSR>>>();
        ICUResourceBundle likelySubtags = LikelySubtagsBuilder.getSupplementalDataBundle("likelySubtags");
        UResource.Value value = likelySubtags.getValueWithFallback("");
        UResource.Table table = value.getTable();
        UResource.Key key = new UResource.Key();
        int i = 0;
        while (table.getKeyAndValue(i, key, value)) {
            LSR ltp = LikelySubtagsBuilder.lsrFromLocaleID(key.toString());
            String language = ltp.language;
            String script = ltp.script;
            String region = ltp.region;
            ltp = LikelySubtagsBuilder.lsrFromLocaleID(value.getString());
            String languageTarget = ltp.language;
            String scriptTarget = ltp.script;
            String regionTarget = ltp.region;
            LikelySubtagsBuilder.set(result, language, script, region, languageTarget, scriptTarget, regionTarget);
            Set<String> languageAliases = languageAliasesBuilder.getAliases(language);
            Set<String> regionAliases = regionAliasesBuilder.getAliases(region);
            for (String languageAlias : languageAliases) {
                for (String regionAlias : regionAliases) {
                    if (languageAlias.equals(language) && regionAlias.equals(region)) continue;
                    LikelySubtagsBuilder.set(result, languageAlias, script, regionAlias, languageTarget, scriptTarget, regionTarget);
                }
            }
            ++i;
        }
        LikelySubtagsBuilder.set(result, "und", "Latn", "", "en", "Latn", "US");
        Map undScriptMap = (Map)result.get("und");
        Map undEmptyRegionMap = (Map)undScriptMap.get("");
        for (Map.Entry regionEntry : undEmptyRegionMap.entrySet()) {
            LSR lsr = (LSR)regionEntry.getValue();
            LikelySubtagsBuilder.set(result, "und", lsr.script, lsr.region, lsr);
        }
        if (!result.containsKey("und")) {
            throw new IllegalArgumentException("failure: base");
        }
        for (Map.Entry langEntry : result.entrySet()) {
            String lang = (String)langEntry.getKey();
            Map scriptMap = (Map)langEntry.getValue();
            if (!scriptMap.containsKey("")) {
                String string = String.valueOf(lang);
                throw new IllegalArgumentException(string.length() != 0 ? "failure: ".concat(string) : new String("failure: "));
            }
            for (Map.Entry scriptEntry : scriptMap.entrySet()) {
                String script = (String)scriptEntry.getKey();
                Map regionMap = (Map)scriptEntry.getValue();
                if (regionMap.containsKey("")) continue;
                throw new IllegalArgumentException(new StringBuilder(10 + String.valueOf(lang).length() + String.valueOf(script).length()).append("failure: ").append(lang).append("-").append(script).toString());
            }
        }
        return result;
    }

    private static LSR lsrFromLocaleID(String languageIdentifier) {
        String[] parts = languageIdentifier.split("[-_]");
        if (parts.length < 1 || parts.length > 3) {
            throw new ICUException("too many subtags");
        }
        String lang = parts[0];
        String p2 = parts.length < 2 ? "" : parts[1];
        String p3 = parts.length < 3 ? "" : parts[2];
        return p2.length() < 4 ? new LSR(lang, "", p2) : new LSR(lang, p2, p3);
    }

    private static void set(Map<String, Map<String, Map<String, LSR>>> langTable, String language, String script, String region, String languageTarget, String scriptTarget, String regionTarget) {
        LSR target = new LSR(languageTarget, scriptTarget, regionTarget);
        LikelySubtagsBuilder.set(langTable, language, script, region, target);
    }

    private static void set(Map<String, Map<String, Map<String, LSR>>> langTable, String language, String script, String region, LSR newValue) {
        Map<String, Map<String, LSR>> scriptTable = LikelySubtagsBuilder.getSubtable(langTable, language);
        Map<String, LSR> regionTable = LikelySubtagsBuilder.getSubtable(scriptTable, script);
        regionTable.put(region, newValue);
    }

    private static <K, V, T> Map<V, T> getSubtable(Map<K, Map<V, T>> table, K language) {
        Map<V, T> subTable = table.get(language);
        if (subTable == null) {
            subTable = new TreeMap<V, T>();
            table.put(language, subTable);
        }
        return subTable;
    }

    private static final class TrieBuilder {
        byte[] bytes = new byte[24];
        BytesTrieBuilder tb = new BytesTrieBuilder();

        private TrieBuilder() {
        }

        void addMapping(String s, int value) {
            s.getBytes(0, s.length(), this.bytes, 0);
            this.tb.add(this.bytes, s.length(), value);
        }

        BytesTrie build() {
            ByteBuffer buffer = this.tb.buildByteBuffer(StringTrieBuilder.Option.SMALL);
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return new BytesTrie(bytes, 0);
        }
    }

    private static final class AliasesBuilder {
        final Map<String, String> toCanonical = new HashMap<String, String>();
        final XCldrStub.Multimap<String, String> toAliases;

        public Set<String> getAliases(String canonical) {
            Set<String> aliases = this.toAliases.get(canonical);
            return aliases == null ? Collections.singleton(canonical) : aliases;
        }

        public AliasesBuilder(String type) {
            ICUResourceBundle metadata = LikelySubtagsBuilder.getSupplementalDataBundle("metadata");
            String string = String.valueOf(type);
            UResource.Value value = metadata.getValueWithFallback(string.length() != 0 ? "alias/".concat(string) : new String("alias/"));
            UResource.Table aliases = value.getTable();
            UResource.Key key = new UResource.Key();
            int i = 0;
            while (aliases.getKeyAndValue(i, key, value)) {
                UResource.Table table;
                String aliasFrom = key.toString();
                if (!(aliasFrom.contains("_") || (table = value.getTable()).findValue("reason", value) && value.getString().equals("overlong") || !table.findValue("replacement", value))) {
                    String aliasFirst;
                    String aliasTo = value.getString();
                    int spacePos = aliasTo.indexOf(32);
                    String string2 = aliasFirst = spacePos < 0 ? aliasTo : aliasTo.substring(0, spacePos);
                    if (!aliasFirst.contains("_")) {
                        this.toCanonical.put(aliasFrom, aliasFirst);
                    }
                }
                ++i;
            }
            if (type.equals("language")) {
                this.toCanonical.put("mo", "ro");
            }
            this.toAliases = XCldrStub.Multimaps.invertFrom(this.toCanonical, XCldrStub.HashMultimap.create());
        }
    }
}

