/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.UResource;
import com.ibm.icu.impl.locale.LSR;
import com.ibm.icu.impl.locale.LocaleDistance;
import com.ibm.icu.impl.locale.XCldrStub;
import com.ibm.icu.impl.locale.XLikelySubtags;
import com.ibm.icu.util.BytesTrie;
import com.ibm.icu.util.BytesTrieBuilder;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.StringTrieBuilder;
import com.ibm.icu.util.ULocale;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class LocaleDistanceBuilder {
    private static final String ANY = "\ufffd";
    private static final boolean DEBUG_OUTPUT = false;

    private static String fixAny(String string) {
        return "*".equals(string) ? ANY : string;
    }

    private static ICUResourceBundle getSupplementalDataBundle(String name) {
        return ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt64b", name, ICUResourceBundle.ICU_DATA_CLASS_LOADER, ICUResourceBundle.OpenType.DIRECT);
    }

    private static final <T> int makeUniqueIndex(Map<T, Integer> objectToInt, T source) {
        Integer result = objectToInt.get(source);
        if (result == null) {
            int newResult = objectToInt.size();
            objectToInt.put(source, newResult);
            return newResult;
        }
        return result;
    }

    private static Collection<String> getIdsFromVariable(XCldrStub.Multimap<String, String> variableToPartition, String variable) {
        if (variable.equals("*")) {
            return Collections.singleton("*");
        }
        Set<String> result = variableToPartition.get(variable);
        if (result == null || result.isEmpty()) {
            String string = String.valueOf(variable);
            throw new IllegalArgumentException(string.length() != 0 ? "Variable not defined: ".concat(string) : new String("Variable not defined: "));
        }
        return result;
    }

    static LocaleDistance build() {
        List<String> supported;
        List<String> desired;
        ICUResourceBundle supplementalData = LocaleDistanceBuilder.getSupplementalDataBundle("supplementalData");
        String[] paradigms = supplementalData.getValueWithFallback("languageMatchingInfo/written/paradigmLocales").getStringArray();
        HashSet<LSR> paradigmLSRs = new HashSet<LSR>();
        for (String paradigm : paradigms) {
            ULocale pl = new ULocale(paradigm);
            paradigmLSRs.add(XLikelySubtags.INSTANCE.makeMaximizedLsrFrom(pl));
        }
        TerritoryContainment tc = new TerritoryContainment(supplementalData);
        RegionMapperBuilder rmb = new RegionMapperBuilder(tc);
        UResource.Value value = supplementalData.getValueWithFallback("languageMatchingInfo/written/matchVariable");
        UResource.Table variables = value.getTable();
        UResource.Key key = new UResource.Key();
        int i = 0;
        while (variables.getKeyAndValue(i, key, value)) {
            String string = String.valueOf(key.toString());
            String variable = string.length() != 0 ? "$".concat(string) : new String("$");
            String regions = value.getString();
            rmb.add(variable, regions);
            ++i;
        }
        XCldrStub.Splitter bar = XCldrStub.Splitter.on('_');
        int prevSize = 0;
        value = supplementalData.getValueWithFallback("languageMatchingNew/written");
        UResource.Array matches = value.getArray();
        ArrayList<Rule> rules = new ArrayList<Rule>(matches.getSize());
        int i2 = 0;
        while (matches.getValue(i2, value)) {
            String[] tuple = value.getStringArray();
            int distance = Integer.parseInt(tuple[2]);
            boolean oneway = tuple.length >= 4 && tuple[3].equals("1");
            desired = new ArrayList<String>(bar.splitToList(tuple[0]));
            supported = new ArrayList<String>(bar.splitToList(tuple[1]));
            int size = desired.size();
            if (size != supported.size()) {
                throw new IllegalArgumentException("uneven languageMatches pair");
            }
            if (size < prevSize) {
                throw new IllegalArgumentException("languageMatches out of order");
            }
            prevSize = size;
            int langStars = LocaleDistanceBuilder.checkStars(desired.get(0), supported.get(0), false);
            if (size >= 2) {
                LocaleDistanceBuilder.checkStars(desired.get(1), supported.get(1), langStars == 2);
            }
            if (size == 3) {
                LocaleDistanceBuilder.checkStars(desired.get(2), supported.get(2), langStars == 2);
                rmb.ensureRegionIsVariable(desired);
                rmb.ensureRegionIsVariable(supported);
            }
            rules.add(new Rule(desired, supported, distance, oneway));
            ++i2;
        }
        rmb.build();
        XCldrStub.Multimap<String, String> variableToPartition = rmb.variableToPartitions;
        DistanceTable defaultDistanceTable = new DistanceTable(-1);
        for (Rule rule : rules) {
            desired = rule.desired;
            supported = rule.supported;
            if (rule.desired.size() <= 2) {
                LocaleDistanceBuilder.add(defaultDistanceTable, desired, supported, rule.distance);
                if (rule.oneway || desired.equals(supported)) continue;
                LocaleDistanceBuilder.add(defaultDistanceTable, supported, desired, rule.distance);
                continue;
            }
            Collection<String> desiredRegions = LocaleDistanceBuilder.getIdsFromVariable(variableToPartition, desired.get(2));
            Collection<String> supportedRegions = LocaleDistanceBuilder.getIdsFromVariable(variableToPartition, supported.get(2));
            for (String desiredRegion2 : desiredRegions) {
                desired.set(2, desiredRegion2.toString());
                for (String supportedRegion2 : supportedRegions) {
                    supported.set(2, supportedRegion2.toString());
                    LocaleDistanceBuilder.add(defaultDistanceTable, desired, supported, rule.distance);
                    if (rule.oneway) continue;
                    LocaleDistanceBuilder.add(defaultDistanceTable, supported, desired, rule.distance);
                }
            }
        }
        TrieBuilder trieBuilder = new TrieBuilder();
        defaultDistanceTable.toTrie(trieBuilder);
        BytesTrie trie = trieBuilder.build();
        return new LocaleDistance(trie, rmb.regionToPartitionsIndex, rmb.partitionArrays, paradigmLSRs);
    }

    private static int checkStars(String desired, String supported, boolean allStars) {
        int stars = (desired.equals("*") ? 1 : 0) + (supported.equals("*") ? 1 : 0);
        if (stars == 1) {
            throw new IllegalArgumentException(new StringBuilder(49 + String.valueOf(desired).length() + String.valueOf(supported).length()).append("either both or neither rule subtags must be *: ").append(desired).append(", ").append(supported).toString());
        }
        if (allStars && stars != 2) {
            throw new IllegalArgumentException(new StringBuilder(77 + String.valueOf(desired).length() + String.valueOf(supported).length()).append("both language subtags are * --> both rule subtags on all levels must be *: ").append(desired).append(", ").append(supported).toString());
        }
        return stars;
    }

    private static void add(DistanceTable languageDesired2Supported, List<String> desired, List<String> supported, int percentage) {
        int size = desired.size();
        if (size != supported.size() || size < 1 || size > 3) {
            throw new IllegalArgumentException();
        }
        String desiredLang = LocaleDistanceBuilder.fixAny(desired.get(0));
        String supportedLang = LocaleDistanceBuilder.fixAny(supported.get(0));
        if (size == 1) {
            languageDesired2Supported.addSubtable(desiredLang, supportedLang, percentage);
        } else {
            String desiredScript = LocaleDistanceBuilder.fixAny(desired.get(1));
            String supportedScript = LocaleDistanceBuilder.fixAny(supported.get(1));
            if (size == 2) {
                languageDesired2Supported.addSubtables(desiredLang, supportedLang, desiredScript, supportedScript, percentage);
            } else {
                String desiredRegion = LocaleDistanceBuilder.fixAny(desired.get(2));
                String supportedRegion = LocaleDistanceBuilder.fixAny(supported.get(2));
                languageDesired2Supported.addSubtables(desiredLang, supportedLang, desiredScript, supportedScript, desiredRegion, supportedRegion, percentage);
            }
        }
    }

    private static final class RegionSet {
        private final TerritoryContainment tc;
        private final Set<String> tempRegions = new TreeSet<String>();
        private Operation operation = null;

        RegionSet(TerritoryContainment tc) {
            this.tc = tc;
        }

        private Set<String> parseSet(String barString) {
            int i;
            this.operation = Operation.add;
            int last = 0;
            this.tempRegions.clear();
            block4: for (i = 0; i < barString.length(); ++i) {
                char c = barString.charAt(i);
                switch (c) {
                    case '+': {
                        this.add(barString, last, i);
                        last = i + 1;
                        this.operation = Operation.add;
                        continue block4;
                    }
                    case '-': {
                        this.add(barString, last, i);
                        last = i + 1;
                        this.operation = Operation.remove;
                    }
                }
            }
            this.add(barString, last, i);
            return this.tempRegions;
        }

        private Set<String> inverse() {
            TreeSet<String> result = new TreeSet<String>(this.tc.leaves);
            result.removeAll(this.tempRegions);
            return result;
        }

        private void add(String barString, int last, int i) {
            if (i > last) {
                String region = barString.substring(last, i);
                this.changeSet(this.operation, region);
            }
        }

        private void changeSet(Operation operation, String region) {
            Set<String> contained = this.tc.toLeavesOnly.get(region);
            if (contained != null && !contained.isEmpty()) {
                if (Operation.add == operation) {
                    this.tempRegions.addAll(contained);
                } else {
                    this.tempRegions.removeAll(contained);
                }
            } else if (Operation.add == operation) {
                this.tempRegions.add(region);
            } else {
                this.tempRegions.remove(region);
            }
        }

        private static enum Operation {
            add,
            remove;

        }
    }

    private static final class RegionMapperBuilder {
        private final Set<String> variables = new HashSet<String>();
        private final XCldrStub.Multimap<String, String> regionToRawPartition = XCldrStub.TreeMultimap.create();
        private final RegionSet regionSet;
        private final TerritoryContainment tc;
        XCldrStub.Multimap<String, String> variableToPartitions;
        private byte[] regionToPartitionsIndex;
        private String[][] partitionArrays;

        RegionMapperBuilder(TerritoryContainment tc) {
            this.regionSet = new RegionSet(tc);
            this.tc = tc;
        }

        private boolean isKnownVariable(String variable) {
            return this.variables.contains(variable) || variable.equals("*");
        }

        void add(String variable, String barString) {
            String inverseVariable;
            assert (!this.isKnownVariable(variable));
            assert (variable.startsWith("$"));
            assert (!variable.startsWith("$!"));
            this.variables.add(variable);
            Set tempRegions = this.regionSet.parseSet(barString);
            for (String region : tempRegions) {
                this.regionToRawPartition.put(region, variable);
            }
            Set inverse = this.regionSet.inverse();
            String string = String.valueOf(variable.substring(1));
            String string2 = inverseVariable = string.length() != 0 ? "$!".concat(string) : new String("$!");
            assert (!this.isKnownVariable(inverseVariable));
            this.variables.add(inverseVariable);
            for (String region : inverse) {
                this.regionToRawPartition.put(region, inverseVariable);
            }
        }

        void ensureRegionIsVariable(List<String> lsrList) {
            String region = lsrList.get(2);
            if (!this.isKnownVariable(region)) {
                assert (LSR.indexForRegion(region) >= 0);
                String string = String.valueOf(region);
                String variable = string.length() != 0 ? "$".concat(string) : new String("$");
                this.add(variable, region);
                lsrList.set(2, variable);
            }
        }

        void build() {
            String macro;
            LinkedHashMap partitionVariables = new LinkedHashMap();
            LinkedHashMap partitionStrings = new LinkedHashMap();
            Set<String> noPartitions = Collections.singleton("");
            LocaleDistanceBuilder.makeUniqueIndex(partitionStrings, noPartitions);
            this.variableToPartitions = XCldrStub.TreeMultimap.create();
            this.regionToPartitionsIndex = new byte[1676];
            XCldrStub.TreeMultimap<String, String> partitionToRegions = XCldrStub.TreeMultimap.create();
            for (Map.Entry<String, Set<String>> entry : this.regionToRawPartition.asMap().entrySet()) {
                String string = entry.getKey();
                Collection rawPartition = entry.getValue();
                char partitionChar = (char)(48 + LocaleDistanceBuilder.makeUniqueIndex(partitionVariables, rawPartition));
                assert (partitionChar <= '\u007f');
                String partition = String.valueOf(partitionChar);
                int pIndex = LocaleDistanceBuilder.makeUniqueIndex(partitionStrings, Collections.singleton(partition));
                assert (pIndex <= 127);
                this.regionToPartitionsIndex[LSR.indexForRegion((String)string)] = (byte)pIndex;
                partitionToRegions.put(partition, string);
                for (String variable : rawPartition) {
                    this.variableToPartitions.put(variable, partition);
                }
            }
            XCldrStub.TreeMultimap<String, String> macroToPartitions = XCldrStub.TreeMultimap.create();
            for (Map.Entry<String, Set<String>> entry : this.tc.resolved.asMap().entrySet()) {
                macro = entry.getKey();
                for (Map.Entry e2 : partitionToRegions.asMap().entrySet()) {
                    String partition = (String)e2.getKey();
                    if (Collections.disjoint((Collection)entry.getValue(), e2.getValue())) continue;
                    macroToPartitions.put(macro, partition);
                }
            }
            for (Map.Entry entry : macroToPartitions.asMap().entrySet()) {
                macro = (String)entry.getKey();
                int regionIndex = LSR.indexForRegion(macro);
                if (this.regionToPartitionsIndex[regionIndex] != 0) continue;
                Set partitions = entry.getValue();
                int pIndex = LocaleDistanceBuilder.makeUniqueIndex(partitionStrings, partitions);
                this.regionToPartitionsIndex[regionIndex] = (byte)pIndex;
            }
            Set set = partitionStrings.keySet();
            this.partitionArrays = new String[set.size()][];
            boolean bl = false;
            for (Collection partitions : set) {
                this.partitionArrays[++var7_16] = partitions.toArray(new String[partitions.size()]);
            }
        }
    }

    private static final class AddSub
    implements XCldrStub.Predicate<DistanceTable> {
        private final String desiredSub;
        private final String supportedSub;
        private final CopyIfEmpty r;

        AddSub(String desiredSub, String supportedSub, DistanceTable distanceTableToCopy) {
            this.r = new CopyIfEmpty(distanceTableToCopy);
            this.desiredSub = desiredSub;
            this.supportedSub = supportedSub;
        }

        @Override
        public boolean test(DistanceTable node) {
            if (node == null) {
                throw new IllegalArgumentException("bad structure");
            }
            node.addSubtables(this.desiredSub, this.supportedSub, this.r);
            return true;
        }
    }

    private static final class CopyIfEmpty
    implements XCldrStub.Predicate<DistanceTable> {
        private final DistanceTable toCopy;

        CopyIfEmpty(DistanceTable resetIfNotNull) {
            this.toCopy = resetIfNotNull;
        }

        @Override
        public boolean test(DistanceTable node) {
            if (node.subtables.isEmpty()) {
                node.copy(this.toCopy);
            }
            return true;
        }
    }

    private static final class DistanceTable {
        final int nodeDistance;
        final Map<String, Map<String, DistanceTable>> subtables;

        DistanceTable(int distance) {
            this.nodeDistance = distance;
            this.subtables = new TreeMap<String, Map<String, DistanceTable>>();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (obj == null) return false;
            if (obj.getClass() != this.getClass()) return false;
            DistanceTable other = (DistanceTable)obj;
            if (this.nodeDistance != other.nodeDistance) return false;
            if (!this.subtables.equals(other.subtables)) return false;
            return true;
        }

        public int hashCode() {
            return this.nodeDistance ^ this.subtables.hashCode();
        }

        public int getDistance(String desired, String supported, Output<DistanceTable> distanceTable, boolean starEquals) {
            DistanceTable value;
            boolean star = false;
            Map<String, DistanceTable> sub2 = this.subtables.get(desired);
            if (sub2 == null) {
                sub2 = this.subtables.get(LocaleDistanceBuilder.ANY);
                star = true;
            }
            if ((value = sub2.get(supported)) == null) {
                value = sub2.get(LocaleDistanceBuilder.ANY);
                if (value == null && !star && (value = (sub2 = this.subtables.get(LocaleDistanceBuilder.ANY)).get(supported)) == null) {
                    value = sub2.get(LocaleDistanceBuilder.ANY);
                }
                star = true;
            }
            if (distanceTable != null) {
                distanceTable.value = value;
            }
            int result = starEquals && star && desired.equals(supported) ? 0 : value.nodeDistance;
            return result;
        }

        void copy(DistanceTable other) {
            for (Map.Entry<String, Map<String, DistanceTable>> e1 : other.subtables.entrySet()) {
                for (Map.Entry<String, DistanceTable> e2 : e1.getValue().entrySet()) {
                    DistanceTable value = e2.getValue();
                    this.addSubtable(e1.getKey(), e2.getKey(), value.nodeDistance);
                }
            }
        }

        DistanceTable addSubtable(String desired, String supported, int distance) {
            DistanceTable oldNode;
            Map<String, DistanceTable> sub2 = this.subtables.get(desired);
            if (sub2 == null) {
                sub2 = new TreeMap<String, DistanceTable>();
                this.subtables.put(desired, sub2);
            }
            if ((oldNode = sub2.get(supported)) != null) {
                return oldNode;
            }
            DistanceTable newNode = new DistanceTable(distance);
            sub2.put(supported, newNode);
            return newNode;
        }

        private DistanceTable getNode(String desired, String supported) {
            Map<String, DistanceTable> sub2 = this.subtables.get(desired);
            if (sub2 == null) {
                return null;
            }
            return sub2.get(supported);
        }

        void addSubtables(String desired, String supported, XCldrStub.Predicate<DistanceTable> action) {
            DistanceTable node = this.getNode(desired, supported);
            if (node == null) {
                Output<DistanceTable> node2 = new Output<DistanceTable>();
                int distance = this.getDistance(desired, supported, node2, true);
                node = this.addSubtable(desired, supported, distance);
                if (node2.value != null) {
                    DistanceTable nextTable = (DistanceTable)node2.value;
                    node.copy(nextTable);
                }
            }
            action.test(node);
        }

        void addSubtables(String desiredLang, String supportedLang, String desiredScript, String supportedScript, int percentage) {
            boolean haveKeys = false;
            for (Map.Entry<String, Map<String, DistanceTable>> e1 : this.subtables.entrySet()) {
                String key1 = e1.getKey();
                boolean desiredIsKey = desiredLang.equals(key1);
                if (!desiredIsKey && !desiredLang.equals(LocaleDistanceBuilder.ANY)) continue;
                for (Map.Entry<String, DistanceTable> e2 : e1.getValue().entrySet()) {
                    String key2 = e2.getKey();
                    boolean supportedIsKey = supportedLang.equals(key2);
                    haveKeys |= desiredIsKey && supportedIsKey;
                    if (!supportedIsKey && !supportedLang.equals(LocaleDistanceBuilder.ANY)) continue;
                    DistanceTable value = e2.getValue();
                    value.addSubtable(desiredScript, supportedScript, percentage);
                }
            }
            DistanceTable dt = new DistanceTable(-1);
            dt.addSubtable(desiredScript, supportedScript, percentage);
            CopyIfEmpty r = new CopyIfEmpty(dt);
            this.addSubtables(desiredLang, supportedLang, r);
        }

        void addSubtables(String desiredLang, String supportedLang, String desiredScript, String supportedScript, String desiredRegion, String supportedRegion, int percentage) {
            boolean haveKeys = false;
            for (Map.Entry<String, Map<String, DistanceTable>> e1 : this.subtables.entrySet()) {
                String key1 = e1.getKey();
                boolean desiredIsKey = desiredLang.equals(key1);
                if (!desiredIsKey && !desiredLang.equals(LocaleDistanceBuilder.ANY)) continue;
                for (Map.Entry<String, DistanceTable> e2 : e1.getValue().entrySet()) {
                    String key2 = e2.getKey();
                    boolean supportedIsKey = supportedLang.equals(key2);
                    haveKeys |= desiredIsKey && supportedIsKey;
                    if (!supportedIsKey && !supportedLang.equals(LocaleDistanceBuilder.ANY)) continue;
                    DistanceTable value = e2.getValue();
                    value.addSubtables(desiredScript, supportedScript, desiredRegion, supportedRegion, percentage);
                }
            }
            DistanceTable dt = new DistanceTable(-1);
            dt.addSubtable(desiredRegion, supportedRegion, percentage);
            AddSub r = new AddSub(desiredScript, supportedScript, dt);
            this.addSubtables(desiredLang, supportedLang, r);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("distance: ").append(this.nodeDistance).append('\n');
            return this.toString("", sb).toString();
        }

        private StringBuilder toString(String indent, StringBuilder buffer) {
            String indent2 = indent.isEmpty() ? "" : "\t";
            for (Map.Entry<String, Map<String, DistanceTable>> e1 : this.subtables.entrySet()) {
                Map<String, DistanceTable> subsubtable = e1.getValue();
                buffer.append(indent2).append(e1.getKey());
                String indent3 = "\t";
                for (Map.Entry<String, DistanceTable> e2 : subsubtable.entrySet()) {
                    DistanceTable value = e2.getValue();
                    buffer.append(indent3).append(e2.getKey());
                    buffer.append('\t').append(value.nodeDistance);
                    value.toString(String.valueOf(indent).concat("\t\t\t"), buffer);
                    buffer.append('\n');
                    indent3 = new StringBuilder(1 + String.valueOf(indent).length()).append(indent).append('\t').toString();
                }
                indent2 = indent;
            }
            return buffer;
        }

        void toTrie(TrieBuilder builder) {
            int startLength = builder.length;
            for (Map.Entry<String, Map<String, DistanceTable>> desSuppNode : this.subtables.entrySet()) {
                String desired = desSuppNode.getKey();
                Map<String, DistanceTable> suppNodeMap = desSuppNode.getValue();
                if (desired.equals(LocaleDistanceBuilder.ANY)) {
                    assert (suppNodeMap.size() == 1);
                    DistanceTable node = suppNodeMap.get(LocaleDistanceBuilder.ANY);
                    builder.addStar(node.nodeDistance);
                    node.toTrie(builder);
                } else {
                    builder.addSubtag(desired, 0);
                    int desiredLength = builder.length;
                    for (Map.Entry<String, DistanceTable> suppNode : suppNodeMap.entrySet()) {
                        String supported = suppNode.getKey();
                        assert (!supported.equals(LocaleDistanceBuilder.ANY));
                        DistanceTable node = suppNode.getValue();
                        builder.addSubtag(supported, node.nodeDistance);
                        node.toTrie(builder);
                        builder.length = desiredLength;
                    }
                }
                builder.length = startLength;
            }
        }
    }

    private static final class TrieBuilder {
        byte[] bytes = new byte[24];
        int length = 0;
        BytesTrieBuilder tb = new BytesTrieBuilder();

        private TrieBuilder() {
        }

        void addStar(int value) {
            assert (value >= 0);
            this.bytes[this.length++] = 42;
            this.tb.add(this.bytes, this.length, value);
        }

        void addSubtag(String s, int value) {
            char c;
            assert (!s.isEmpty());
            assert (value >= 0);
            assert (!s.equals(LocaleDistanceBuilder.ANY));
            int end = s.length() - 1;
            int i = 0;
            while (true) {
                c = s.charAt(i);
                assert (c <= '\u007f');
                if (i >= end) break;
                this.bytes[this.length++] = (byte)c;
                ++i;
            }
            this.bytes[this.length++] = (byte)(c | 0x80);
            this.tb.add(this.bytes, this.length, value);
        }

        BytesTrie build() {
            ByteBuffer buffer = this.tb.buildByteBuffer(StringTrieBuilder.Option.SMALL);
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return new BytesTrie(bytes, 0);
        }
    }

    private static final class Rule {
        final List<String> desired;
        final List<String> supported;
        final int distance;
        final boolean oneway;

        Rule(List<String> desired, List<String> supported, int distance, boolean oneway) {
            this.desired = desired;
            this.supported = supported;
            this.distance = distance;
            this.oneway = oneway;
        }
    }

    private static final class TerritoryContainment {
        final XCldrStub.Multimap<String, String> graph = XCldrStub.TreeMultimap.create();
        final XCldrStub.Multimap<String, String> resolved = XCldrStub.TreeMultimap.create();
        final XCldrStub.Multimap<String, String> toLeavesOnly = XCldrStub.TreeMultimap.create();
        final Set<String> leaves;

        TerritoryContainment(ICUResourceBundle supplementalData) {
            UResource.Value value = supplementalData.getValueWithFallback("territoryContainment");
            UResource.Key key = new UResource.Key();
            this.addContainments(key, value);
            this.resolve("001");
            for (Map.Entry<String, Set<String>> entry : this.resolved.asMap().entrySet()) {
                String container = entry.getKey();
                for (String contained : entry.getValue()) {
                    if (this.resolved.get(contained) != null) continue;
                    this.toLeavesOnly.put(container, contained);
                }
            }
            this.leaves = this.toLeavesOnly.get("001");
        }

        private void addContainments(UResource.Key key, UResource.Value value) {
            UResource.Table containers = value.getTable();
            int i = 0;
            while (containers.getKeyAndValue(i, key, value)) {
                if (key.length() <= 3) {
                    String[] contents;
                    String container = key.toString();
                    for (String s : contents = value.getStringArrayOrStringAsArray()) {
                        this.graph.put(container, s);
                    }
                } else {
                    this.addContainments(key, value);
                }
                ++i;
            }
        }

        private Set<String> resolve(String region) {
            Set<String> contained = this.graph.get(region);
            if (contained == null) {
                return Collections.emptySet();
            }
            this.resolved.putAll(region, (Collection<String>)contained);
            for (String subregion : contained) {
                this.resolved.putAll(region, (Collection<String>)this.resolve(subregion));
            }
            return this.resolved.get(region);
        }
    }
}

