/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number;

import com.ibm.icu.impl.StaticUnicodeSets;
import com.ibm.icu.text.ConstrainedFieldPosition;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UnicodeSet;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.FieldPosition;
import java.text.Format;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class NumberStringBuilder
implements CharSequence {
    public static final NumberStringBuilder EMPTY = new NumberStringBuilder();
    private char[] chars;
    private Format.Field[] fields;
    private int zero;
    private int length;
    private static final Map<Format.Field, Character> fieldToDebugChar = new HashMap<Format.Field, Character>();

    public NumberStringBuilder() {
        this(40);
    }

    public NumberStringBuilder(int capacity) {
        this.chars = new char[capacity];
        this.fields = new Format.Field[capacity];
        this.zero = capacity / 2;
        this.length = 0;
    }

    public NumberStringBuilder(NumberStringBuilder source) {
        this.copyFrom(source);
    }

    public void copyFrom(NumberStringBuilder source) {
        this.chars = Arrays.copyOf(source.chars, source.chars.length);
        this.fields = Arrays.copyOf(source.fields, source.fields.length);
        this.zero = source.zero;
        this.length = source.length;
    }

    @Override
    public int length() {
        return this.length;
    }

    public int codePointCount() {
        return Character.codePointCount(this, 0, this.length());
    }

    @Override
    public char charAt(int index) {
        assert (index >= 0);
        assert (index < this.length);
        return this.chars[this.zero + index];
    }

    public Format.Field fieldAt(int index) {
        assert (index >= 0);
        assert (index < this.length);
        return this.fields[this.zero + index];
    }

    public int getFirstCodePoint() {
        if (this.length == 0) {
            return -1;
        }
        return Character.codePointAt(this.chars, this.zero, this.zero + this.length);
    }

    public int getLastCodePoint() {
        if (this.length == 0) {
            return -1;
        }
        return Character.codePointBefore(this.chars, this.zero + this.length, this.zero);
    }

    public int codePointAt(int index) {
        return Character.codePointAt(this.chars, this.zero + index, this.zero + this.length);
    }

    public int codePointBefore(int index) {
        return Character.codePointBefore(this.chars, this.zero + index, this.zero);
    }

    public NumberStringBuilder clear() {
        this.zero = this.getCapacity() / 2;
        this.length = 0;
        return this;
    }

    public int appendCodePoint(int codePoint, Format.Field field) {
        return this.insertCodePoint(this.length, codePoint, field);
    }

    public int insertCodePoint(int index, int codePoint, Format.Field field) {
        int count = Character.charCount(codePoint);
        int position = this.prepareForInsert(index, count);
        Character.toChars(codePoint, this.chars, position);
        this.fields[position] = field;
        if (count == 2) {
            this.fields[position + 1] = field;
        }
        return count;
    }

    public int append(CharSequence sequence, Format.Field field) {
        return this.insert(this.length, sequence, field);
    }

    public int insert(int index, CharSequence sequence, Format.Field field) {
        if (sequence.length() == 0) {
            return 0;
        }
        if (sequence.length() == 1) {
            return this.insertCodePoint(index, sequence.charAt(0), field);
        }
        return this.insert(index, sequence, 0, sequence.length(), field);
    }

    public int insert(int index, CharSequence sequence, int start, int end, Format.Field field) {
        int count = end - start;
        int position = this.prepareForInsert(index, count);
        for (int i = 0; i < count; ++i) {
            this.chars[position + i] = sequence.charAt(start + i);
            this.fields[position + i] = field;
        }
        return count;
    }

    public int splice(int startThis, int endThis, CharSequence sequence, int startOther, int endOther, Format.Field field) {
        int otherLength = endOther - startOther;
        int thisLength = endThis - startThis;
        int count = otherLength - thisLength;
        int position = count > 0 ? this.prepareForInsert(startThis, count) : this.remove(startThis, -count);
        for (int i = 0; i < otherLength; ++i) {
            this.chars[position + i] = sequence.charAt(startOther + i);
            this.fields[position + i] = field;
        }
        return count;
    }

    public int append(char[] chars, Format.Field[] fields) {
        return this.insert(this.length, chars, fields);
    }

    public int insert(int index, char[] chars, Format.Field[] fields) {
        assert (fields == null || chars.length == fields.length);
        int count = chars.length;
        if (count == 0) {
            return 0;
        }
        int position = this.prepareForInsert(index, count);
        for (int i = 0; i < count; ++i) {
            this.chars[position + i] = chars[i];
            this.fields[position + i] = fields == null ? null : fields[i];
        }
        return count;
    }

    public int append(NumberStringBuilder other) {
        return this.insert(this.length, other);
    }

    public int insert(int index, NumberStringBuilder other) {
        if (this == other) {
            throw new IllegalArgumentException("Cannot call insert/append on myself");
        }
        int count = other.length;
        if (count == 0) {
            return 0;
        }
        int position = this.prepareForInsert(index, count);
        for (int i = 0; i < count; ++i) {
            this.chars[position + i] = other.charAt(i);
            this.fields[position + i] = other.fieldAt(i);
        }
        return count;
    }

    private int prepareForInsert(int index, int count) {
        if (index == 0 && this.zero - count >= 0) {
            this.zero -= count;
            this.length += count;
            return this.zero;
        }
        if (index == this.length && this.zero + this.length + count < this.getCapacity()) {
            this.length += count;
            return this.zero + this.length - count;
        }
        return this.prepareForInsertHelper(index, count);
    }

    private int prepareForInsertHelper(int index, int count) {
        int oldCapacity = this.getCapacity();
        int oldZero = this.zero;
        char[] oldChars = this.chars;
        Format.Field[] oldFields = this.fields;
        if (this.length + count > oldCapacity) {
            int newCapacity = (this.length + count) * 2;
            int newZero = newCapacity / 2 - (this.length + count) / 2;
            char[] newChars = new char[newCapacity];
            Format.Field[] newFields = new Format.Field[newCapacity];
            System.arraycopy(oldChars, oldZero, newChars, newZero, index);
            System.arraycopy(oldChars, oldZero + index, newChars, newZero + index + count, this.length - index);
            System.arraycopy(oldFields, oldZero, newFields, newZero, index);
            System.arraycopy(oldFields, oldZero + index, newFields, newZero + index + count, this.length - index);
            this.chars = newChars;
            this.fields = newFields;
            this.zero = newZero;
            this.length += count;
        } else {
            int newZero = oldCapacity / 2 - (this.length + count) / 2;
            System.arraycopy(oldChars, oldZero, oldChars, newZero, this.length);
            System.arraycopy(oldChars, newZero + index, oldChars, newZero + index + count, this.length - index);
            System.arraycopy(oldFields, oldZero, oldFields, newZero, this.length);
            System.arraycopy(oldFields, newZero + index, oldFields, newZero + index + count, this.length - index);
            this.zero = newZero;
            this.length += count;
        }
        return this.zero + index;
    }

    private int remove(int index, int count) {
        int position = index + this.zero;
        System.arraycopy(this.chars, position + count, this.chars, position, this.length - index - count);
        System.arraycopy(this.fields, position + count, this.fields, position, this.length - index - count);
        this.length -= count;
        return position;
    }

    private int getCapacity() {
        return this.chars.length;
    }

    @Override
    @Deprecated
    public CharSequence subSequence(int start, int end) {
        assert (start >= 0);
        assert (end <= this.length);
        assert (end >= start);
        NumberStringBuilder other = new NumberStringBuilder(this);
        other.zero = this.zero + start;
        other.length = end - start;
        return other;
    }

    public String subString(int start, int end) {
        if (start < 0 || end > this.length || end < start) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.chars, start + this.zero, end - start);
    }

    @Override
    public String toString() {
        return new String(this.chars, this.zero, this.length);
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<NumberStringBuilder [");
        sb.append(this.toString());
        sb.append("] [");
        for (int i = this.zero; i < this.zero + this.length; ++i) {
            if (this.fields[i] == null) {
                sb.append('n');
                continue;
            }
            sb.append(fieldToDebugChar.get(this.fields[i]));
        }
        sb.append("]>");
        return sb.toString();
    }

    public char[] toCharArray() {
        return Arrays.copyOfRange(this.chars, this.zero, this.zero + this.length);
    }

    public Format.Field[] toFieldArray() {
        return Arrays.copyOfRange(this.fields, this.zero, this.zero + this.length);
    }

    public boolean contentEquals(char[] chars, Format.Field[] fields) {
        if (chars.length != this.length) {
            return false;
        }
        if (fields.length != this.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.chars[this.zero + i] != chars[i]) {
                return false;
            }
            if (this.fields[this.zero + i] == fields[i]) continue;
            return false;
        }
        return true;
    }

    public boolean contentEquals(NumberStringBuilder other) {
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.charAt(i) == other.charAt(i) && this.fieldAt(i) == other.fieldAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Don't call #hashCode() or #equals() on a mutable.");
    }

    public boolean equals(Object other) {
        throw new UnsupportedOperationException("Don't call #hashCode() or #equals() on a mutable.");
    }

    public boolean nextFieldPosition(FieldPosition fp) {
        Format.Field rawField = fp.getFieldAttribute();
        if (rawField == null) {
            if (fp.getField() == 0) {
                rawField = NumberFormat.Field.INTEGER;
            } else if (fp.getField() == 1) {
                rawField = NumberFormat.Field.FRACTION;
            } else {
                return false;
            }
        }
        if (!(rawField instanceof NumberFormat.Field)) {
            String string = String.valueOf(rawField.getClass().toString());
            throw new IllegalArgumentException(string.length() != 0 ? "You must pass an instance of com.ibm.icu.text.NumberFormat.Field as your FieldPosition attribute.  You passed: ".concat(string) : new String("You must pass an instance of com.ibm.icu.text.NumberFormat.Field as your FieldPosition attribute.  You passed: "));
        }
        ConstrainedFieldPosition cfpos = new ConstrainedFieldPosition();
        cfpos.constrainField(rawField);
        cfpos.setState(rawField, null, fp.getBeginIndex(), fp.getEndIndex());
        if (this.nextPosition(cfpos, null)) {
            fp.setBeginIndex(cfpos.getStart());
            fp.setEndIndex(cfpos.getLimit());
            return true;
        }
        if (rawField == NumberFormat.Field.FRACTION && fp.getEndIndex() == 0) {
            int i;
            boolean inside = false;
            for (i = this.zero; i < this.zero + this.length; ++i) {
                if (NumberStringBuilder.isIntOrGroup(this.fields[i]) || this.fields[i] == NumberFormat.Field.DECIMAL_SEPARATOR) {
                    inside = true;
                    continue;
                }
                if (inside) break;
            }
            fp.setBeginIndex(i - this.zero);
            fp.setEndIndex(i - this.zero);
        }
        return false;
    }

    public AttributedCharacterIterator toCharacterIterator(Format.Field numericField) {
        ConstrainedFieldPosition cfpos = new ConstrainedFieldPosition();
        AttributedString as = new AttributedString(this.toString());
        while (this.nextPosition(cfpos, numericField)) {
            as.addAttribute(cfpos.getField(), cfpos.getField(), cfpos.getStart(), cfpos.getLimit());
        }
        return as.getIterator();
    }

    public boolean nextPosition(ConstrainedFieldPosition cfpos, Format.Field numericField) {
        int fieldStart = -1;
        NullField currField = null;
        for (int i = this.zero + cfpos.getLimit(); i <= this.zero + this.length; ++i) {
            int j;
            NullField _field;
            Format.Field field = _field = i < this.zero + this.length ? this.fields[i] : NullField.END;
            if (currField != null) {
                if (currField == _field) continue;
                int end = i - this.zero;
                if (currField != NumberFormat.Field.GROUPING_SEPARATOR) {
                    end = this.trimBack(end);
                }
                if (end <= fieldStart) {
                    fieldStart = -1;
                    currField = null;
                    --i;
                    continue;
                }
                int start = fieldStart;
                if (currField != NumberFormat.Field.GROUPING_SEPARATOR) {
                    start = this.trimFront(start);
                }
                cfpos.setState(currField, null, start, end);
                return true;
            }
            if (cfpos.matchesField(NumberFormat.Field.INTEGER, null) && i > this.zero && i - this.zero > cfpos.getLimit() && NumberStringBuilder.isIntOrGroup(this.fields[i - 1]) && !NumberStringBuilder.isIntOrGroup(_field)) {
                for (j = i - 1; j >= this.zero && NumberStringBuilder.isIntOrGroup(this.fields[j]); --j) {
                }
                cfpos.setState(NumberFormat.Field.INTEGER, null, j - this.zero + 1, i - this.zero);
                return true;
            }
            if (numericField != null && cfpos.matchesField(numericField, null) && i > this.zero && (i - this.zero > cfpos.getLimit() || cfpos.getField() != numericField) && NumberStringBuilder.isNumericField(this.fields[i - 1]) && !NumberStringBuilder.isNumericField(_field)) {
                for (j = i - 1; j >= this.zero && NumberStringBuilder.isNumericField(this.fields[j]); --j) {
                }
                cfpos.setState(numericField, null, j - this.zero + 1, i - this.zero);
                return true;
            }
            if (_field == NumberFormat.Field.INTEGER) {
                _field = null;
            }
            if (_field == null || _field == NullField.END || !cfpos.matchesField(_field, null)) continue;
            fieldStart = i - this.zero;
            currField = _field;
        }
        assert (currField == null);
        return false;
    }

    private static boolean isIntOrGroup(Format.Field field) {
        return field == NumberFormat.Field.INTEGER || field == NumberFormat.Field.GROUPING_SEPARATOR;
    }

    private static boolean isNumericField(Format.Field field) {
        return field == null || NumberFormat.Field.class.isAssignableFrom(field.getClass());
    }

    private int trimBack(int limit) {
        return StaticUnicodeSets.get(StaticUnicodeSets.Key.DEFAULT_IGNORABLES).spanBack(this, limit, UnicodeSet.SpanCondition.CONTAINED);
    }

    private int trimFront(int start) {
        return StaticUnicodeSets.get(StaticUnicodeSets.Key.DEFAULT_IGNORABLES).span(this, start, UnicodeSet.SpanCondition.CONTAINED);
    }

    static {
        fieldToDebugChar.put(NumberFormat.Field.SIGN, Character.valueOf('-'));
        fieldToDebugChar.put(NumberFormat.Field.INTEGER, Character.valueOf('i'));
        fieldToDebugChar.put(NumberFormat.Field.FRACTION, Character.valueOf('f'));
        fieldToDebugChar.put(NumberFormat.Field.EXPONENT, Character.valueOf('e'));
        fieldToDebugChar.put(NumberFormat.Field.EXPONENT_SIGN, Character.valueOf('+'));
        fieldToDebugChar.put(NumberFormat.Field.EXPONENT_SYMBOL, Character.valueOf('E'));
        fieldToDebugChar.put(NumberFormat.Field.DECIMAL_SEPARATOR, Character.valueOf('.'));
        fieldToDebugChar.put(NumberFormat.Field.GROUPING_SEPARATOR, Character.valueOf(','));
        fieldToDebugChar.put(NumberFormat.Field.PERCENT, Character.valueOf('%'));
        fieldToDebugChar.put(NumberFormat.Field.PERMILLE, Character.valueOf('\u2030'));
        fieldToDebugChar.put(NumberFormat.Field.CURRENCY, Character.valueOf('$'));
        fieldToDebugChar.put(NumberFormat.Field.MEASURE_UNIT, Character.valueOf('u'));
        fieldToDebugChar.put(NumberFormat.Field.COMPACT, Character.valueOf('C'));
    }

    static class NullField
    extends Format.Field {
        private static final long serialVersionUID = 1L;
        static final NullField END = new NullField("end");

        private NullField(String name) {
            super(name);
        }
    }
}

