/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import java.io.Serializable;
import java.util.Date;

public abstract class TimeZoneRule
implements Serializable {
    private static final long serialVersionUID = 6374143828553768100L;
    private final String name;
    private final int rawOffset;
    private final int dstSavings;

    public TimeZoneRule(String name, int rawOffset, int dstSavings) {
        this.name = name;
        this.rawOffset = rawOffset;
        this.dstSavings = dstSavings;
    }

    public String getName() {
        return this.name;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public boolean isEquivalentTo(TimeZoneRule other) {
        return this.rawOffset == other.rawOffset && this.dstSavings == other.dstSavings;
    }

    public abstract Date getFirstStart(int var1, int var2);

    public abstract Date getFinalStart(int var1, int var2);

    public abstract Date getNextStart(long var1, int var3, int var4, boolean var5);

    public abstract Date getPreviousStart(long var1, int var3, int var4, boolean var5);

    public abstract boolean isTransitionRule();

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String string = String.valueOf(this.name);
        buf.append(string.length() != 0 ? "name=".concat(string) : new String("name="));
        int n = this.rawOffset;
        buf.append(new StringBuilder(23).append(", stdOffset=").append(n).toString());
        n = this.dstSavings;
        buf.append(new StringBuilder(23).append(", dstSaving=").append(n).toString());
        return buf.toString();
    }
}

