/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.grpc;

import com.google.common.annotations.Beta;
import com.google.common.base.CaseFormat;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.gapi.gax.protobuf.ProtoReflectionUtil;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

@Beta
public class GrpcForwardingAdapter {
    private static final Logger logger = Logger.getLogger(GrpcForwardingAdapter.class.getName());
    private final ServerServiceDefinition definition;

    public GrpcForwardingAdapter(Descriptors.ServiceDescriptor service, Descriptors.ServiceDescriptor delegateService, AbstractStub<?> delegate) throws IllegalArgumentException, ReflectiveOperationException {
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder(service.getFullName());
        for (Descriptors.MethodDescriptor serviceMethod : service.getMethods()) {
            Descriptors.MethodDescriptor delegateMethod = delegateService.findMethodByName(serviceMethod.getName());
            MethodHandler handler = MethodHandler.create(serviceMethod, delegateMethod, delegate);
            builder.addMethod(handler.getDescriptor(), handler);
        }
        this.definition = builder.build();
    }

    public ServerServiceDefinition getDefinition() {
        return this.definition;
    }

    private static final class BidiStreamingMethodHandler<ReqT extends Message, RespT extends Message, DelegateReqT extends Message, DelegateRespT extends Message>
    extends StreamingRequestMethodHandler<ReqT, RespT, DelegateReqT, DelegateRespT> {
        BidiStreamingMethodHandler(Descriptors.MethodDescriptor method, Descriptors.MethodDescriptor delegateMethod, AbstractStub<?> delegate) throws ReflectiveOperationException {
            super(method, delegateMethod, delegate, MethodDescriptor.MethodType.BIDI_STREAMING);
        }

        @Override
        protected ServerCallHandler<ReqT, RespT> getHandler() {
            return ServerCalls.asyncBidiStreamingCall(new ServerCalls.BidiStreamingMethod<ReqT, RespT>(){

                @Override
                public StreamObserver<ReqT> invoke(StreamObserver<RespT> streamObserver) {
                    return this.makeCall(streamObserver);
                }
            });
        }
    }

    private static final class ClientStreamingMethodHandler<ReqT extends Message, RespT extends Message, DelegateReqT extends Message, DelegateRespT extends Message>
    extends StreamingRequestMethodHandler<ReqT, RespT, DelegateReqT, DelegateRespT> {
        ClientStreamingMethodHandler(Descriptors.MethodDescriptor method, Descriptors.MethodDescriptor delegateMethod, AbstractStub<?> delegate) throws ReflectiveOperationException {
            super(method, delegateMethod, delegate, MethodDescriptor.MethodType.CLIENT_STREAMING);
        }

        @Override
        protected ServerCallHandler<ReqT, RespT> getHandler() {
            return ServerCalls.asyncClientStreamingCall(new ServerCalls.ClientStreamingMethod<ReqT, RespT>(){

                @Override
                public StreamObserver<ReqT> invoke(StreamObserver<RespT> streamObserver) {
                    return this.makeCall(streamObserver);
                }
            });
        }
    }

    private static final class ServerStreamingMethodHandler<ReqT extends Message, RespT extends Message, DelegateReqT extends Message, DelegateRespT extends Message>
    extends SingleRequestMethodHandler<ReqT, RespT, DelegateReqT, DelegateRespT> {
        ServerStreamingMethodHandler(Descriptors.MethodDescriptor method, Descriptors.MethodDescriptor delegateMethod, AbstractStub<?> delegate) throws ReflectiveOperationException {
            super(method, delegateMethod, delegate, MethodDescriptor.MethodType.SERVER_STREAMING);
        }

        @Override
        protected ServerCallHandler<ReqT, RespT> getHandler() {
            return ServerCalls.asyncServerStreamingCall(new ServerCalls.ServerStreamingMethod<ReqT, RespT>(){

                @Override
                public void invoke(ReqT reqT, StreamObserver<RespT> streamObserver) {
                    this.makeCall(reqT, streamObserver);
                }
            });
        }
    }

    private static final class UnaryMethodHandler<ReqT extends Message, RespT extends Message, DelegateReqT extends Message, DelegateRespT extends Message>
    extends SingleRequestMethodHandler<ReqT, RespT, DelegateReqT, DelegateRespT> {
        UnaryMethodHandler(Descriptors.MethodDescriptor method, Descriptors.MethodDescriptor delegateMethod, AbstractStub<?> delegate) throws ReflectiveOperationException {
            super(method, delegateMethod, delegate, MethodDescriptor.MethodType.UNARY);
        }

        @Override
        protected ServerCallHandler<ReqT, RespT> getHandler() {
            return ServerCalls.asyncUnaryCall(new ServerCalls.UnaryMethod<ReqT, RespT>(){

                @Override
                public void invoke(ReqT reqT, StreamObserver<RespT> streamObserver) {
                    this.makeCall(reqT, streamObserver);
                }
            });
        }
    }

    static abstract class SingleRequestMethodHandler<ReqT extends Message, RespT extends Message, DelegateReqT extends Message, DelegateRespT extends Message>
    extends MethodHandler<ReqT, RespT, DelegateReqT, DelegateRespT> {
        protected SingleRequestMethodHandler(Descriptors.MethodDescriptor method, Descriptors.MethodDescriptor delegateMethod, AbstractStub<?> delegate, MethodDescriptor.MethodType methodType) throws ReflectiveOperationException {
            super(method, delegateMethod, delegate, methodType, SingleRequestMethodHandler.getJavaMethod(delegateMethod, delegate));
        }

        private static Method getJavaMethod(Descriptors.MethodDescriptor delegateMethod, AbstractStub<?> delegate) throws NoSuchMethodException {
            Message defaultDelegateReq = ProtoReflectionUtil.getDefaultInstance(delegateMethod.getInputType());
            return delegate.getClass().getDeclaredMethod(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, delegateMethod.getName()), defaultDelegateReq.getClass(), StreamObserver.class);
        }

        protected void makeCall(ReqT req, StreamObserver<RespT> streamObserver) {
            StreamObserver responseObserver = SingleRequestMethodHandler.convertObserver(streamObserver, this.defaultResp);
            try {
                Message delegateReq = SingleRequestMethodHandler.convertMessage(req, this.defaultDelegateReq);
                ProtoReflectionUtil.invoke(Void.class, this.javaMethod, (Object)this.delegate, delegateReq, responseObserver);
            }
            catch (InvalidProtocolBufferException e) {
                streamObserver.onError(e);
            }
        }
    }

    private static abstract class StreamingRequestMethodHandler<ReqT extends Message, RespT extends Message, DelegateReqT extends Message, DelegateRespT extends Message>
    extends MethodHandler<ReqT, RespT, DelegateReqT, DelegateRespT> {
        protected StreamingRequestMethodHandler(Descriptors.MethodDescriptor method, Descriptors.MethodDescriptor delegateMethod, AbstractStub<?> delegate, MethodDescriptor.MethodType methodType) throws ReflectiveOperationException {
            super(method, delegateMethod, delegate, methodType, StreamingRequestMethodHandler.getJavaMethod(delegateMethod, delegate));
        }

        private static Method getJavaMethod(Descriptors.MethodDescriptor delegateMethod, AbstractStub<?> delegate) throws NoSuchMethodException {
            return delegate.getClass().getDeclaredMethod(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, delegateMethod.getName()), StreamObserver.class);
        }

        protected StreamObserver<ReqT> makeCall(StreamObserver<RespT> streamObserver) {
            StreamObserver responseObserver = StreamingRequestMethodHandler.convertObserver(streamObserver, this.defaultResp);
            StreamObserver reqObserver = ProtoReflectionUtil.invoke(StreamObserver.class, this.javaMethod, (Object)this.delegate, responseObserver);
            return StreamingRequestMethodHandler.convertObserver(reqObserver, this.defaultDelegateReq);
        }
    }

    private static abstract class MethodHandler<ReqT extends Message, RespT extends Message, DelegateReqT extends Message, DelegateRespT extends Message>
    implements ServerCallHandler<ReqT, RespT> {
        protected final ReqT defaultReq;
        protected final RespT defaultResp;
        protected final DelegateReqT defaultDelegateReq;
        protected final DelegateRespT defaultDelegateResp;
        protected final Method javaMethod;
        protected final Descriptors.MethodDescriptor method;
        protected final AbstractStub<?> delegate;
        private final MethodDescriptor.MethodType methodType;

        protected MethodHandler(Descriptors.MethodDescriptor method, Descriptors.MethodDescriptor delegateMethod, AbstractStub<?> delegate, MethodDescriptor.MethodType methodType, Method javaMethod) throws ReflectiveOperationException {
            this.method = method;
            this.delegate = delegate;
            this.methodType = methodType;
            this.javaMethod = javaMethod;
            this.javaMethod.setAccessible(true);
            this.defaultReq = ProtoReflectionUtil.getDefaultInstance(method.getInputType());
            this.defaultResp = ProtoReflectionUtil.getDefaultInstance(method.getOutputType());
            this.defaultDelegateReq = ProtoReflectionUtil.getDefaultInstance(delegateMethod.getInputType());
            this.defaultDelegateResp = ProtoReflectionUtil.getDefaultInstance(delegateMethod.getOutputType());
        }

        static <ReqT extends Message, RespT extends Message, DelegateReqT extends Message, DelegateRespT extends Message> MethodHandler<ReqT, RespT, DelegateReqT, DelegateRespT> create(Descriptors.MethodDescriptor method, Descriptors.MethodDescriptor delegateMethod, AbstractStub<?> delegate) throws ReflectiveOperationException {
            DescriptorProtos.MethodDescriptorProto descriptor = delegateMethod.toProto();
            if (descriptor.getClientStreaming() && descriptor.getServerStreaming()) {
                return new BidiStreamingMethodHandler(method, delegateMethod, delegate);
            }
            if (descriptor.getClientStreaming()) {
                return new ClientStreamingMethodHandler(method, delegateMethod, delegate);
            }
            if (descriptor.getServerStreaming()) {
                return new ServerStreamingMethodHandler(method, delegateMethod, delegate);
            }
            return new UnaryMethodHandler(method, delegateMethod, delegate);
        }

        MethodDescriptor<ReqT, RespT> getDescriptor() {
            String string = this.method.getService().getFullName();
            String string2 = this.method.getName();
            return MethodDescriptor.create(this.methodType, new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString(), ProtoUtils.marshaller(this.defaultReq), ProtoUtils.marshaller(this.defaultResp));
        }

        protected static <T extends Message, V extends Message> StreamObserver<V> convertObserver(final StreamObserver<T> target, final T defaultT) {
            return new StreamObserver<V>(){

                @Override
                public void onNext(V v) {
                    try {
                        Message.Builder tBuilder = defaultT.newBuilderForType();
                        tBuilder.mergeFrom(v.toByteString());
                        target.onNext(tBuilder.build());
                    }
                    catch (InvalidProtocolBufferException e) {
                        logger.logp(Level.SEVERE, "io.gapi.emulators.grpc.GrpcForwardingAdapter$MethodHandler$1", "onNext", String.format("Formats %s and %s are not wire-compatible.", v.getClass().getName(), defaultT.getClass().getName()));
                        this.onError(e);
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    target.onError(throwable);
                }

                @Override
                public void onCompleted() {
                    target.onCompleted();
                }
            };
        }

        protected static <T extends Message, V extends Message> V convertMessage(T message, V defaultV) throws InvalidProtocolBufferException {
            try {
                return (V)defaultV.newBuilderForType().mergeFrom(message.toByteString()).build();
            }
            catch (InvalidProtocolBufferException e) {
                logger.logp(Level.SEVERE, "io.gapi.emulators.grpc.GrpcForwardingAdapter$MethodHandler", "convertMessage", String.format("Formats %s and %s are not wire-compatible.", message.getClass().getName(), defaultV.getClass().getName()));
                throw e;
            }
        }

        @Override
        public ServerCall.Listener<ReqT> startCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata) {
            return this.getHandler().startCall(serverCall, metadata);
        }

        protected abstract ServerCallHandler<ReqT, RespT> getHandler();
    }
}

