/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.grpc;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import io.gapi.emulators.netty.HttpVersionRoutingHandler;
import io.gapi.emulators.netty.NettyUtil;
import io.gapi.emulators.netty.NotFoundHandler;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

@Beta
public class GrpcServer {
    private static final AsciiString HTTP = AsciiString.of("http");
    private final String host;
    private final int port;
    private final List<ServerServiceDefinition> services;
    private final List<BindableService> bindableServices;
    private final List<ChannelHandler> httpHandlers;
    private final EventExecutorGroup httpGroup;
    private Server server;

    public GrpcServer(String host, int port, List<ServerServiceDefinition> services) {
        this.host = host;
        this.port = port;
        this.services = services;
        this.bindableServices = new ArrayList<BindableService>();
        this.httpHandlers = new ArrayList<ChannelHandler>();
        this.httpGroup = NettyUtil.newEventLoopGroup(1);
    }

    public void addService(ServerServiceDefinition service) {
        this.services.add(service);
    }

    public void addService(BindableService service) {
        this.bindableServices.add(service);
    }

    public void addHttpHandler(ChannelHandler httpHandler) {
        if (httpHandler.getClass().getAnnotation(ChannelHandler.Sharable.class) == null) {
            throw new IllegalArgumentException("Handler is not sharable");
        }
        this.httpHandlers.add(httpHandler);
    }

    public void start() throws IOException {
        NettyUtil.applyJava7LongHostnameWorkaround();
        InetAddress addr = this.host != null && !this.host.isEmpty() ? InetAddress.getByName(this.host) : (GrpcServer.isIPv6OnlyEnabled() ? InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}) : InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
        InetSocketAddress socketAddr = new InetSocketAddress(addr, this.port);
        NettyServerBuilder builder = NettyServerBuilder.forAddress(socketAddr).protocolNegotiator(new InternalProtocolNegotiator.ProtocolNegotiator(){

            @Override
            public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
                return new HttpVersionRoutingHandler(GrpcServer.this.newHttpHandlers(), GrpcServer.this.httpGroup, ImmutableList.of(grpcHandler));
            }

            @Override
            public AsciiString scheme() {
                return HTTP;
            }

            @Override
            public void close() {
            }
        });
        for (ServerServiceDefinition serverServiceDefinition : this.services) {
            builder.addService(serverServiceDefinition);
        }
        for (BindableService bindableService : this.bindableServices) {
            builder.addService(bindableService);
        }
        this.server = builder.build().start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.err.println("*** shutting down gRPC server since JVM is shutting down");
                GrpcServer.this.stop();
                System.err.println("*** server shut down");
            }
        });
    }

    public final void awaitTerminated() throws Exception {
        this.server.awaitTermination();
    }

    public void stop() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    private List<ChannelHandler> newHttpHandlers() {
        ArrayList<ChannelHandler> httpHandlers = new ArrayList<ChannelHandler>();
        httpHandlers.add(new HttpRequestDecoder());
        httpHandlers.add(new HttpResponseEncoder());
        httpHandlers.add(new HttpContentDecompressor());
        httpHandlers.add(new HttpObjectAggregator(0x1000000));
        httpHandlers.addAll(this.httpHandlers);
        httpHandlers.add(new NotFoundHandler());
        return httpHandlers;
    }

    private static boolean isIPv6OnlyEnabled() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!(address instanceof Inet4Address)) continue;
                return false;
            }
        }
        return true;
    }
}

