/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.grpc;

import com.google.common.annotations.Beta;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.gapi.emulators.grpc.HttpAdapter;
import io.gapi.emulators.grpc.JsonFormat;
import io.grpc.Status;
import io.grpc.StatusException;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import org.json.simple.JSONObject;

@ChannelHandler.Sharable
@Beta
public final class HttpJsonAdapter
extends HttpAdapter {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private final JsonFormat.Printer printer;
    private final JsonFormat.Parser parser;

    public HttpJsonAdapter() {
        this(JsonFormat.TypeRegistry.getEmptyTypeRegistry());
    }

    public HttpJsonAdapter(JsonFormat.TypeRegistry registry) {
        this.printer = JsonFormat.printer().usingTypeRegistry(registry);
        this.parser = JsonFormat.parser().usingTypeRegistry(registry);
    }

    @Override
    protected boolean canHandleRequest(FullHttpRequest request) {
        String contentType = HttpJsonAdapter.getContentType(request);
        return contentType.isEmpty() || contentType.contains(JSON_CONTENT_TYPE);
    }

    @Override
    protected void postprocessResponse(FullHttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)JSON_CONTENT_TYPE);
    }

    @Override
    protected void merge(ByteString input, Message.Builder builder) throws InvalidProtocolBufferException {
        this.parser.merge(input.toStringUtf8(), builder);
    }

    @Override
    protected ByteString toResponse(Message message) throws StatusException {
        try {
            return ByteString.copyFromUtf8(HttpJsonAdapter.ensureTrailingNewline(this.printer.print(message)));
        }
        catch (InvalidProtocolBufferException e) {
            throw Status.INTERNAL.withCause(e).asException();
        }
    }

    @Override
    protected ByteString toResponse(Status status) {
        JSONObject error = new JSONObject();
        error.put("code", HttpJsonAdapter.toHttpCode(status.getCode()));
        if (status.getDescription() != null) {
            error.put("message", status.getDescription());
        }
        error.put("status", status.getCode().name());
        JSONObject outer = new JSONObject();
        outer.put("error", error);
        return ByteString.copyFromUtf8(outer.toJSONString());
    }

    private static String ensureTrailingNewline(String s) {
        if (s.isEmpty() || s.charAt(s.length() - 1) == '\n') {
            return s;
        }
        return String.valueOf(s).concat("\n");
    }
}

