/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.grpc;

import com.google.common.annotations.Beta;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.rpc.Status;
import io.gapi.emulators.grpc.HttpAdapter;
import io.grpc.StatusException;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;

@ChannelHandler.Sharable
@Beta
public final class HttpProtoAdapter
extends HttpAdapter {
    private static final String PROTO_CONTENT_TYPE = "application/x-protobuf";

    @Override
    protected boolean canHandleRequest(FullHttpRequest request) {
        return HttpProtoAdapter.getContentType(request).equals(PROTO_CONTENT_TYPE);
    }

    @Override
    protected void postprocessResponse(FullHttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)PROTO_CONTENT_TYPE);
    }

    @Override
    protected void merge(ByteString input, Message.Builder builder) throws InvalidProtocolBufferException {
        builder.mergeFrom(input);
    }

    @Override
    protected ByteString toResponse(Message message) throws StatusException {
        return message.toByteString();
    }

    @Override
    protected ByteString toResponse(io.grpc.Status status) {
        Status.Builder statusBuilder = Status.newBuilder().setCode(status.getCode().value());
        if (status.getDescription() != null) {
            statusBuilder.setMessage(status.getDescription());
        }
        return statusBuilder.build().toByteString();
    }
}

