/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.grpc;

import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SimpleStreamObserver<V>
implements StreamObserver<V> {
    private final List<V> values = new ArrayList<V>();
    private final CountDownLatch completedLatch = new CountDownLatch(1);
    private Throwable error = null;

    @Override
    public synchronized void onNext(V value) {
        this.values.add(value);
    }

    @Override
    public void onError(Throwable t) {
        this.error = t;
        this.completedLatch.countDown();
    }

    @Override
    public void onCompleted() {
        this.completedLatch.countDown();
    }

    public synchronized List<V> getValues() {
        return new ArrayList<V>(this.values);
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean waitUntilCompleted(long timeoutMillis) throws InterruptedException {
        return this.completedLatch.await(timeoutMillis, TimeUnit.MILLISECONDS);
    }
}

