/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.netty;

import com.google.common.annotations.Beta;
import io.grpc.Attributes;
import io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@Beta
public final class HttpVersionRoutingHandler
extends ChannelDuplexHandler {
    private static final Logger logger = Logger.getLogger(HttpVersionRoutingHandler.class.getName());
    private final List<ChannelHandler> nonHttp2Handlers;
    private final EventExecutorGroup nonHttp2EventExecutorGroup;
    private final List<GrpcHttp2ConnectionHandler> http2Handlers;
    private final ByteBuf testBuffer;
    private boolean protocolKnown;

    public HttpVersionRoutingHandler(List<ChannelHandler> nonHttp2Handlers, List<GrpcHttp2ConnectionHandler> http2Handlers) {
        this(nonHttp2Handlers, null, http2Handlers);
    }

    public HttpVersionRoutingHandler(List<ChannelHandler> nonHttp2Handlers, EventExecutorGroup nonHttp2EventExecutorGroup, List<GrpcHttp2ConnectionHandler> http2Handlers) {
        this.nonHttp2Handlers = nonHttp2Handlers;
        this.nonHttp2EventExecutorGroup = nonHttp2EventExecutorGroup;
        this.http2Handlers = http2Handlers;
        this.testBuffer = Unpooled.directBuffer();
        this.protocolKnown = false;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf msgBytes = (ByteBuf)msg;
            if (!this.protocolKnown) {
                this.testBuffer.writeBytes(msgBytes, 0, 24);
                if (this.testBuffer.readableBytes() >= 24) {
                    if (this.testBuffer.slice(0, 24).equals(Http2CodecUtil.connectionPrefaceBuf())) {
                        logger.logp(Level.INFO, "io.gapi.emulators.netty.HttpVersionRoutingHandler", "channelRead", "Detected HTTP/2 connection.");
                        for (GrpcHttp2ConnectionHandler handler : this.http2Handlers) {
                            handler.handleProtocolNegotiationCompleted(Attributes.EMPTY);
                            ctx.pipeline().addLast(handler);
                        }
                    } else {
                        logger.logp(Level.INFO, "io.gapi.emulators.netty.HttpVersionRoutingHandler", "channelRead", "Detected non-HTTP/2 connection.");
                        for (ChannelHandler nonHttp2Handler : this.nonHttp2Handlers) {
                            if (this.nonHttp2EventExecutorGroup != null) {
                                ctx.pipeline().addLast(this.nonHttp2EventExecutorGroup, nonHttp2Handler);
                                continue;
                            }
                            ctx.pipeline().addLast(nonHttp2Handler);
                        }
                    }
                    this.protocolKnown = true;
                }
            }
            if (this.protocolKnown) {
                ctx.fireChannelRead(msgBytes);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }
}

