/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.netty;

import com.google.common.annotations.Beta;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

@Beta
public class NettyUtil {
    private static final Logger logger = Logger.getLogger(NettyUtil.class.getName());
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).build();

    public static EventLoopGroup newEventLoopGroup(int nThreads) {
        return new NioEventLoopGroup(nThreads, threadFactory);
    }

    public static void applyJava7LongHostnameWorkaround() {
        try {
            if (Strings.nullToEmpty(StandardSystemProperty.JAVA_VERSION.value()).startsWith("1.7.")) {
                String pid = new File("/proc/self").getCanonicalFile().getName();
                Integer.parseInt(pid);
                System.setProperty("io.netty.processId", pid);
                logger.logp(Level.INFO, "io.gapi.emulators.netty.NettyUtil", "applyJava7LongHostnameWorkaround", "Applied Java 7 long hostname workaround.");
            }
        }
        catch (IOException | NumberFormatException e) {
            logger.logp(Level.INFO, "io.gapi.emulators.netty.NettyUtil", "applyJava7LongHostnameWorkaround", "Unable to apply Java 7 long hostname workaround.");
        }
    }

    public static class CustomEventLoopGroup
    extends NioEventLoopGroup {
        private final ChannelFutureListener onRegister;

        public CustomEventLoopGroup(ChannelFutureListener onRegister) {
            super(1, Executors.newFixedThreadPool(1, threadFactory));
            this.onRegister = onRegister;
        }

        @Override
        public ChannelFuture register(Channel channel) {
            return super.register(channel).addListener(this.onRegister);
        }

        @Override
        public ChannelFuture register(Channel channel, ChannelPromise promise) {
            return super.register(channel, promise).addListener(this.onRegister);
        }
    }
}

