/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.netty;

import com.google.common.annotations.Beta;
import io.gapi.emulators.netty.SimpleHttpHandler;
import io.gapi.emulators.util.Observer;
import io.gapi.emulators.util.ResetException;
import io.gapi.emulators.util.Resettable;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.regex.Pattern;

@ChannelHandler.Sharable
@Beta
public class ResetHandler
extends SimpleHttpHandler {
    private final Resettable target;

    public ResetHandler(String pathRegex, Resettable target) {
        super("POST", Pattern.compile(pathRegex));
        this.target = target;
    }

    @Override
    protected void handleRequest(FullHttpRequest request, Observer<FullHttpResponse> observer) {
        try {
            this.target.reset();
            observer.onValue(ResetHandler.writeUtf8("Resetting...\n", new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.OK)));
        }
        catch (ResetException e) {
            observer.onError(e);
        }
    }
}

