/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.emulators.netty;

import com.google.common.annotations.Beta;
import io.gapi.emulators.grpc.GrpcServer;
import io.gapi.emulators.netty.SimpleHttpHandler;
import io.gapi.emulators.util.Observer;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

@ChannelHandler.Sharable
@Beta
public class ShutdownHandler
extends SimpleHttpHandler {
    private final GrpcServer server;
    private final Executor executor;

    public ShutdownHandler(String pathRegex, GrpcServer server, Executor executor) {
        super("POST", Pattern.compile(pathRegex));
        this.server = server;
        this.executor = executor;
    }

    @Override
    protected void handleRequest(FullHttpRequest request, Observer<FullHttpResponse> observer) {
        Runnable shutdown = new Runnable(){

            @Override
            public void run() {
                ShutdownHandler.this.server.stop();
            }
        };
        if (this.executor instanceof ScheduledExecutorService) {
            ((ScheduledExecutorService)this.executor).schedule(shutdown, 500L, TimeUnit.MILLISECONDS);
        } else {
            this.executor.execute(shutdown);
        }
        observer.onValue(ShutdownHandler.writeUtf8("Shutting down...\n", new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.OK)));
    }
}

