/*
 * Decompiled with CFR 0.152.
 */
package io.gapi.gax.protobuf;

import com.google.common.base.CaseFormat;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import io.gapi.gax.protobuf.ValidationException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ProtoReflectionUtil {
    public static Class<? extends Message> getMessageClass(DescriptorProtos.FileOptions fileOptions, String packageName, String fileName, String messageName) {
        messageName = ProtoReflectionUtil.fixTypeName(packageName, messageName);
        String javaName = ProtoReflectionUtil.getJavaName(fileOptions, packageName, fileName, messageName);
        try {
            Class<?> type = Class.forName(javaName);
            if (!Message.class.isAssignableFrom(type)) {
                throw new ValidationException("The type '%s' is not a message", type.getName());
            }
            return Class.forName(javaName);
        }
        catch (ClassNotFoundException e) {
            Object[] objectArray = new Object[2];
            String string = messageName.replace('$', '.');
            objectArray[0] = new StringBuilder(1 + String.valueOf(packageName).length() + String.valueOf(string).length()).append(packageName).append(".").append(string).toString();
            objectArray[1] = javaName;
            throw new ValidationException("Cannot resolve type '%s' as mapped to Java type '%s'", objectArray);
        }
    }

    public static Class<? extends ProtocolMessageEnum> getEnumClass(DescriptorProtos.FileOptions fileOptions, String packageName, String fileName, String enumName) {
        enumName = ProtoReflectionUtil.fixTypeName(packageName, enumName);
        String javaName = ProtoReflectionUtil.getJavaName(fileOptions, packageName, fileName, enumName);
        try {
            Class<?> type = Class.forName(javaName);
            if (!ProtocolMessageEnum.class.isAssignableFrom(type)) {
                throw new ValidationException("The type '%s' is not a ProtocolMessageEnum", type.getName());
            }
            return Class.forName(javaName);
        }
        catch (ClassNotFoundException e) {
            Object[] objectArray = new Object[2];
            String string = enumName.replace('$', '.');
            objectArray[0] = new StringBuilder(1 + String.valueOf(packageName).length() + String.valueOf(string).length()).append(packageName).append(".").append(string).toString();
            objectArray[1] = javaName;
            throw new ValidationException("Cannot resolve type '%s' as mapped to Java type '%s'", objectArray);
        }
    }

    public static Message getDefaultInstance(Descriptors.Descriptor message) {
        Class<? extends Message> type = ProtoReflectionUtil.getMessageClass(message.getFile().getOptions(), message.getFile().getPackage(), message.getFile().getName(), message.getFullName());
        if (type != null) {
            return ProtoReflectionUtil.getDefaultInstance(type);
        }
        return DynamicMessage.getDefaultInstance(message);
    }

    public static ProtocolMessageEnum getEnum(Descriptors.EnumValueDescriptor enumValueDescriptor) {
        Descriptors.EnumDescriptor enumDescriptor = enumValueDescriptor.getType();
        Class<? extends ProtocolMessageEnum> type = ProtoReflectionUtil.getEnumClass(enumDescriptor.getFile().getOptions(), enumDescriptor.getFile().getPackage(), enumDescriptor.getFile().getName(), enumDescriptor.getFullName());
        if (type != null) {
            try {
                return ProtoReflectionUtil.invoke(ProtocolMessageEnum.class, type.getMethod("valueOf", Integer.TYPE), null, enumValueDescriptor.getNumber());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (SecurityException e) {
                throw e;
            }
        }
        return null;
    }

    public static Message getDefaultInstance(Class<? extends Message> type) {
        return ProtoReflectionUtil.invoke(Message.class, type, "getDefaultInstance", null, new Object[0]);
    }

    public static <T> T invoke(Class<T> returnType, Method method, Object receiver, Object ... args) {
        try {
            return returnType.cast(method.invoke(receiver, args));
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate(e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw Throwables.propagate(e);
        }
    }

    public static List<Message> invoke(Method method, Object receiver, Object ... args) {
        try {
            Object result = method.invoke(receiver, args);
            if (result instanceof List) {
                return (List)result;
            }
            throw new ValidationException("Method '%s' failed to return list.", method.getName());
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate(e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw Throwables.propagate(e);
        }
    }

    public static <T> T invoke(Class<T> returnType, Class<?> type, String name, Object receiver, Object ... args) {
        try {
            return ProtoReflectionUtil.invoke(returnType, type.getMethod(name, ProtoReflectionUtil.getTypes(args)), receiver, args);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Object getField(GeneratedMessage target, Descriptors.FieldDescriptor field) {
        if (!field.isMapField()) {
            return target.getField(field);
        }
        String string = String.valueOf(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, field.getName()));
        return ProtoReflectionUtil.invoke(Object.class, target.getClass(), string.length() != 0 ? "get".concat(string) : new String("get"), (Object)target, new Object[0]);
    }

    private static Class<?>[] getTypes(Object[] args) {
        Class[] result = new Class[args.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = args[i].getClass();
        }
        return result;
    }

    private static String fixTypeName(String packageName, String typeName) {
        if (typeName.startsWith(String.valueOf(packageName).concat("."))) {
            typeName = typeName.substring(packageName.length() + 1);
        }
        typeName = typeName.replace('.', '$');
        return typeName;
    }

    private static String getJavaName(DescriptorProtos.FileOptions fileOptions, String packageName, String fileName, String typeName) {
        String javaName = fileOptions.getJavaPackage();
        if (javaName.isEmpty()) {
            String string = String.valueOf(packageName);
            String string2 = javaName = string.length() != 0 ? "com.google.protos.".concat(string) : new String("com.google.protos.");
        }
        if (!fileOptions.getJavaMultipleFiles()) {
            String string;
            if (fileOptions.hasJavaOuterClassname()) {
                string = javaName;
                String string3 = fileOptions.getJavaOuterClassname();
                javaName = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append(".").append(string3).toString();
            } else {
                fileName = Files.getNameWithoutExtension(new File(fileName).getName());
                string = javaName;
                String string4 = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, fileName);
                javaName = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string4).length()).append(string).append(".").append(string4).toString();
            }
            string = javaName;
            javaName = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(typeName).length()).append(string).append("$").append(typeName).toString();
        } else {
            String string = javaName;
            javaName = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(typeName).length()).append(string).append(".").append(typeName).toString();
        }
        return javaName;
    }
}

