/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.okhttp.internal.framed.ErrorCode;
import io.grpc.okhttp.internal.framed.Header;
import io.grpc.okhttp.internal.framed.Settings;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.Buffer;
import okio.ByteString;

class OkHttpFrameLogger {
    private static final int BUFFER_LENGTH_THRESHOLD = 64;
    private final Logger logger;
    private final Level level;

    OkHttpFrameLogger(Level level, Class<?> clazz) {
        this(level, Logger.getLogger(clazz.getName()));
    }

    @VisibleForTesting
    OkHttpFrameLogger(Level level, Logger logger) {
        this.level = Preconditions.checkNotNull(level, "level");
        this.logger = Preconditions.checkNotNull(logger, "logger");
    }

    private static String toString(Settings settings) {
        EnumMap<SettingParams, Integer> map = new EnumMap<SettingParams, Integer>(SettingParams.class);
        for (SettingParams p : SettingParams.values()) {
            if (!settings.isSet(p.getBit())) continue;
            map.put(p, settings.get(p.getBit()));
        }
        return map.toString();
    }

    private static String toString(Buffer buf) {
        if (buf.size() <= 64L) {
            return buf.snapshot().hex();
        }
        int length = (int)Math.min(buf.size(), 64L);
        return String.valueOf(buf.snapshot(length).hex()).concat("...");
    }

    private boolean isEnabled() {
        return this.logger.isLoggable(this.level);
    }

    void logData(Direction direction, int streamId, Buffer data, int length, boolean endStream) {
        if (this.isEnabled()) {
            String string = String.valueOf((Object)direction);
            String string2 = OkHttpFrameLogger.toString(data);
            this.logger.logp(this.level, "io.grpc.okhttp.OkHttpFrameLogger", "logData", new StringBuilder(69 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" DATA: streamId=").append(streamId).append(" endStream=").append(endStream).append(" length=").append(length).append(" bytes=").append(string2).toString());
        }
    }

    void logHeaders(Direction direction, int streamId, List<Header> headers, boolean endStream) {
        if (this.isEnabled()) {
            String string = String.valueOf((Object)direction);
            String string2 = String.valueOf(headers);
            this.logger.logp(this.level, "io.grpc.okhttp.OkHttpFrameLogger", "logHeaders", new StringBuilder(55 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" HEADERS: streamId=").append(streamId).append(" headers=").append(string2).append(" endStream=").append(endStream).toString());
        }
    }

    public void logPriority(Direction direction, int streamId, int streamDependency, int weight, boolean exclusive) {
        if (this.isEnabled()) {
            String string = String.valueOf((Object)direction);
            this.logger.logp(this.level, "io.grpc.okhttp.OkHttpFrameLogger", "logPriority", new StringBuilder(95 + String.valueOf(string).length()).append(string).append(" PRIORITY: streamId=").append(streamId).append(" streamDependency=").append(streamDependency).append(" weight=").append(weight).append(" exclusive=").append(exclusive).toString());
        }
    }

    void logRstStream(Direction direction, int streamId, ErrorCode errorCode) {
        if (this.isEnabled()) {
            String string = String.valueOf((Object)direction);
            String string2 = String.valueOf((Object)errorCode);
            this.logger.logp(this.level, "io.grpc.okhttp.OkHttpFrameLogger", "logRstStream", new StringBuilder(44 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" RST_STREAM: streamId=").append(streamId).append(" errorCode=").append(string2).toString());
        }
    }

    void logSettingsAck(Direction direction) {
        if (this.isEnabled()) {
            String string = String.valueOf((Object)direction);
            this.logger.logp(this.level, "io.grpc.okhttp.OkHttpFrameLogger", "logSettingsAck", new StringBuilder(19 + String.valueOf(string).length()).append(string).append(" SETTINGS: ack=true").toString());
        }
    }

    void logSettings(Direction direction, Settings settings) {
        if (this.isEnabled()) {
            String string = String.valueOf((Object)direction);
            String string2 = OkHttpFrameLogger.toString(settings);
            this.logger.logp(this.level, "io.grpc.okhttp.OkHttpFrameLogger", "logSettings", new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" SETTINGS: ack=false settings=").append(string2).toString());
        }
    }

    void logPing(Direction direction, long data) {
        if (this.isEnabled()) {
            String string = String.valueOf((Object)direction);
            this.logger.logp(this.level, "io.grpc.okhttp.OkHttpFrameLogger", "logPing", new StringBuilder(43 + String.valueOf(string).length()).append(string).append(" PING: ack=false bytes=").append(data).toString());
        }
    }

    void logPingAck(Direction direction, long data) {
        if (this.isEnabled()) {
            String string = String.valueOf((Object)direction);
            this.logger.logp(this.level, "io.grpc.okhttp.OkHttpFrameLogger", "logPingAck", new StringBuilder(42 + String.valueOf(string).length()).append(string).append(" PING: ack=true bytes=").append(data).toString());
        }
    }

    void logPushPromise(Direction direction, int streamId, int promisedStreamId, List<Header> headers) {
        if (this.isEnabled()) {
            String string = String.valueOf((Object)direction);
            String string2 = String.valueOf(headers);
            this.logger.logp(this.level, "io.grpc.okhttp.OkHttpFrameLogger", "logPushPromise", new StringBuilder(73 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" PUSH_PROMISE: streamId=").append(streamId).append(" promisedStreamId=").append(promisedStreamId).append(" headers=").append(string2).toString());
        }
    }

    void logGoAway(Direction direction, int lastStreamId, ErrorCode errorCode, ByteString debugData) {
        if (this.isEnabled()) {
            String string = String.valueOf((Object)direction);
            String string2 = String.valueOf((Object)errorCode);
            int n = debugData.size();
            String string3 = OkHttpFrameLogger.toString(new Buffer().write(debugData));
            this.logger.logp(this.level, "io.grpc.okhttp.OkHttpFrameLogger", "logGoAway", new StringBuilder(71 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(" GO_AWAY: lastStreamId=").append(lastStreamId).append(" errorCode=").append(string2).append(" length=").append(n).append(" bytes=").append(string3).toString());
        }
    }

    void logWindowsUpdate(Direction direction, int streamId, long windowSizeIncrement) {
        if (this.isEnabled()) {
            String string = String.valueOf((Object)direction);
            this.logger.logp(this.level, "io.grpc.okhttp.OkHttpFrameLogger", "logWindowsUpdate", new StringBuilder(77 + String.valueOf(string).length()).append(string).append(" WINDOW_UPDATE: streamId=").append(streamId).append(" windowSizeIncrement=").append(windowSizeIncrement).toString());
        }
    }

    private static enum SettingParams {
        HEADER_TABLE_SIZE(1),
        ENABLE_PUSH(2),
        MAX_CONCURRENT_STREAMS(4),
        MAX_FRAME_SIZE(5),
        MAX_HEADER_LIST_SIZE(6),
        INITIAL_WINDOW_SIZE(7);

        private final int bit;

        private SettingParams(int bit) {
            this.bit = bit;
        }

        public int getBit() {
            return this.bit;
        }
    }

    static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

