/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.okhttp.internal.OptionalMethod;
import io.grpc.okhttp.internal.Platform;
import io.grpc.okhttp.internal.Protocol;
import io.grpc.okhttp.internal.Util;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocket;

class OkHttpProtocolNegotiator {
    private static final Logger logger = Logger.getLogger(OkHttpProtocolNegotiator.class.getName());
    private static final Platform DEFAULT_PLATFORM = Platform.get();
    private static OkHttpProtocolNegotiator NEGOTIATOR = OkHttpProtocolNegotiator.createNegotiator(OkHttpProtocolNegotiator.class.getClassLoader());
    protected final Platform platform;

    @VisibleForTesting
    OkHttpProtocolNegotiator(Platform platform) {
        this.platform = Preconditions.checkNotNull(platform, "platform");
    }

    public static OkHttpProtocolNegotiator get() {
        return NEGOTIATOR;
    }

    @VisibleForTesting
    static OkHttpProtocolNegotiator createNegotiator(ClassLoader loader) {
        boolean android = true;
        try {
            loader.loadClass("com.android.org.conscrypt.OpenSSLSocketImpl");
        }
        catch (ClassNotFoundException e1) {
            logger.logp(Level.FINE, "io.grpc.okhttp.OkHttpProtocolNegotiator", "createNegotiator", "Unable to find Conscrypt. Skipping", e1);
            try {
                loader.loadClass("org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl");
            }
            catch (ClassNotFoundException e2) {
                logger.logp(Level.FINE, "io.grpc.okhttp.OkHttpProtocolNegotiator", "createNegotiator", "Unable to find any OpenSSLSocketImpl. Skipping", e2);
                android = false;
            }
        }
        return android ? new AndroidNegotiator(DEFAULT_PLATFORM) : new OkHttpProtocolNegotiator(DEFAULT_PLATFORM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String negotiate(SSLSocket sslSocket, String hostname, @Nullable List<Protocol> protocols) throws IOException {
        if (protocols != null) {
            this.configureTlsExtensions(sslSocket, hostname, protocols);
        }
        try {
            sslSocket.startHandshake();
            String negotiatedProtocol = this.getSelectedProtocol(sslSocket);
            if (negotiatedProtocol == null) {
                String string = String.valueOf(protocols);
                throw new RuntimeException(new StringBuilder(44 + String.valueOf(string).length()).append("TLS ALPN negotiation failed with protocols: ").append(string).toString());
            }
            String string = negotiatedProtocol;
            return string;
        }
        finally {
            this.platform.afterHandshake(sslSocket);
        }
    }

    protected void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        this.platform.configureTlsExtensions(sslSocket, hostname, protocols);
    }

    public String getSelectedProtocol(SSLSocket socket) {
        return this.platform.getSelectedProtocol(socket);
    }

    @VisibleForTesting
    static final class AndroidNegotiator
    extends OkHttpProtocolNegotiator {
        private static final OptionalMethod<Socket> SET_USE_SESSION_TICKETS = new OptionalMethod(null, "setUseSessionTickets", Boolean.TYPE);
        private static final OptionalMethod<Socket> SET_HOSTNAME = new OptionalMethod(null, "setHostname", String.class);
        private static final OptionalMethod<Socket> GET_ALPN_SELECTED_PROTOCOL = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
        private static final OptionalMethod<Socket> SET_ALPN_PROTOCOLS = new OptionalMethod(null, "setAlpnProtocols", byte[].class);
        private static final OptionalMethod<Socket> GET_NPN_SELECTED_PROTOCOL = new OptionalMethod(byte[].class, "getNpnSelectedProtocol", new Class[0]);
        private static final OptionalMethod<Socket> SET_NPN_PROTOCOLS = new OptionalMethod(null, "setNpnProtocols", byte[].class);

        AndroidNegotiator(Platform platform) {
            super(platform);
        }

        @Override
        public String negotiate(SSLSocket sslSocket, String hostname, List<Protocol> protocols) throws IOException {
            String negotiatedProtocol = this.getSelectedProtocol(sslSocket);
            if (negotiatedProtocol == null) {
                negotiatedProtocol = super.negotiate(sslSocket, hostname, protocols);
            }
            return negotiatedProtocol;
        }

        @Override
        protected void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
            if (hostname != null) {
                SET_USE_SESSION_TICKETS.invokeOptionalWithoutCheckedException(sslSocket, true);
                SET_HOSTNAME.invokeOptionalWithoutCheckedException(sslSocket, hostname);
            }
            Object[] parameters = new Object[]{Platform.concatLengthPrefixed(protocols)};
            if (this.platform.getTlsExtensionType() == Platform.TlsExtensionType.ALPN_AND_NPN) {
                SET_ALPN_PROTOCOLS.invokeWithoutCheckedException(sslSocket, parameters);
            }
            if (this.platform.getTlsExtensionType() == Platform.TlsExtensionType.NONE) {
                throw new RuntimeException("We can not do TLS handshake on this Android version, please install the Google Play Services Dynamic Security Provider to use TLS");
            }
            SET_NPN_PROTOCOLS.invokeWithoutCheckedException(sslSocket, parameters);
        }

        @Override
        public String getSelectedProtocol(SSLSocket socket) {
            if (this.platform.getTlsExtensionType() == Platform.TlsExtensionType.ALPN_AND_NPN) {
                try {
                    byte[] alpnResult = (byte[])GET_ALPN_SELECTED_PROTOCOL.invokeWithoutCheckedException(socket, new Object[0]);
                    if (alpnResult != null) {
                        return new String(alpnResult, Util.UTF_8);
                    }
                }
                catch (Exception e) {
                    logger.logp(Level.FINE, "io.grpc.okhttp.OkHttpProtocolNegotiator$AndroidNegotiator", "getSelectedProtocol", "Failed calling getAlpnSelectedProtocol()", e);
                }
            }
            if (this.platform.getTlsExtensionType() != Platform.TlsExtensionType.NONE) {
                try {
                    byte[] npnResult = (byte[])GET_NPN_SELECTED_PROTOCOL.invokeWithoutCheckedException(socket, new Object[0]);
                    if (npnResult != null) {
                        return new String(npnResult, Util.UTF_8);
                    }
                }
                catch (Exception e) {
                    logger.logp(Level.FINE, "io.grpc.okhttp.OkHttpProtocolNegotiator$AndroidNegotiator", "getSelectedProtocol", "Failed calling getNpnSelectedProtocol()", e);
                }
            }
            return null;
        }
    }
}

