/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.Native;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

final class TcpMd5Util {
    static Collection<InetAddress> newTcpMd5Sigs(AbstractEpollChannel channel, Collection<InetAddress> current, Map<InetAddress, byte[]> newKeys) throws IOException {
        ObjectUtil.checkNotNull(channel, "channel");
        ObjectUtil.checkNotNull(current, "current");
        ObjectUtil.checkNotNull(newKeys, "newKeys");
        for (Map.Entry<InetAddress, byte[]> e : newKeys.entrySet()) {
            byte[] key = e.getValue();
            if (e.getKey() == null) {
                String string = String.valueOf(newKeys);
                throw new IllegalArgumentException(new StringBuilder(45 + String.valueOf(string).length()).append("newKeys contains an entry with null address: ").append(string).toString());
            }
            if (key == null) {
                String string = String.valueOf(e.getKey());
                throw new NullPointerException(new StringBuilder(9 + String.valueOf(string).length()).append("newKeys[").append(string).append(']').toString());
            }
            if (key.length == 0) {
                String string = String.valueOf(e.getKey());
                throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(string).length()).append("newKeys[").append(string).append("] has an empty key.").toString());
            }
            if (key.length <= Native.TCP_MD5SIG_MAXKEYLEN) continue;
            String string = String.valueOf(e.getKey());
            int n = Native.TCP_MD5SIG_MAXKEYLEN;
            throw new IllegalArgumentException(new StringBuilder(91 + String.valueOf(string).length()).append("newKeys[").append(string).append("] has a key with invalid length; should not exceed the maximum length (").append(n).append(')').toString());
        }
        for (InetAddress addr : current) {
            if (newKeys.containsKey(addr)) continue;
            channel.socket.setTcpMd5Sig(addr, null);
        }
        if (newKeys.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(newKeys.size());
        for (Map.Entry<InetAddress, byte[]> e : newKeys.entrySet()) {
            channel.socket.setTcpMd5Sig(e.getKey(), e.getValue());
            addresses.add(e.getKey());
        }
        return addresses;
    }

    private TcpMd5Util() {
    }
}

