/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.common;

import com.google.auto.value.AutoValue;
import io.opencensus.common.AutoValue_Duration;
import io.opencensus.common.TimeUtils;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class Duration
implements Comparable<Duration> {
    public static Duration create(long seconds, int nanos) {
        if (seconds < -315576000000L) {
            throw new IllegalArgumentException(new StringBuilder(68).append("'seconds' is less than minimum (-315576000000): ").append(seconds).toString());
        }
        if (seconds > 315576000000L) {
            throw new IllegalArgumentException(new StringBuilder(70).append("'seconds' is greater than maximum (315576000000): ").append(seconds).toString());
        }
        if (nanos < -999999999) {
            throw new IllegalArgumentException(new StringBuilder(54).append("'nanos' is less than minimum (-999999999): ").append(nanos).toString());
        }
        if (nanos > 999999999) {
            throw new IllegalArgumentException(new StringBuilder(56).append("'nanos' is greater than maximum (999999999): ").append(nanos).toString());
        }
        if (seconds < 0L && nanos > 0 || seconds > 0L && nanos < 0) {
            throw new IllegalArgumentException(new StringBuilder(93).append("'seconds' and 'nanos' have inconsistent sign: seconds=").append(seconds).append(", nanos=").append(nanos).toString());
        }
        return new AutoValue_Duration(seconds, nanos);
    }

    public static Duration fromMillis(long millis) {
        long seconds = millis / 1000L;
        int nanos = (int)(millis % 1000L * 1000000L);
        return Duration.create(seconds, nanos);
    }

    public long toMillis() {
        return TimeUnit.SECONDS.toMillis(this.getSeconds()) + TimeUnit.NANOSECONDS.toMillis(this.getNanos());
    }

    public abstract long getSeconds();

    public abstract int getNanos();

    @Override
    public int compareTo(Duration otherDuration) {
        int cmp = TimeUtils.compareLongs(this.getSeconds(), otherDuration.getSeconds());
        if (cmp != 0) {
            return cmp;
        }
        return TimeUtils.compareLongs(this.getNanos(), otherDuration.getNanos());
    }

    Duration() {
    }
}

