/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.common;

import io.opencensus.common.ServerStats;
import io.opencensus.common.ServerStatsDeserializationException;
import io.opencensus.common.ServerStatsFieldEnums;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class ServerStatsEncoding {
    public static final byte CURRENT_VERSION = 0;

    private ServerStatsEncoding() {
    }

    public static byte[] toBytes(ServerStats stats) {
        ByteBuffer bb = ByteBuffer.allocate(ServerStatsFieldEnums.getTotalSize() + 1);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.put((byte)0);
        bb.put((byte)ServerStatsFieldEnums.Id.SERVER_STATS_LB_LATENCY_ID.value());
        bb.putLong(stats.getLbLatencyNs());
        bb.put((byte)ServerStatsFieldEnums.Id.SERVER_STATS_SERVICE_LATENCY_ID.value());
        bb.putLong(stats.getServiceLatencyNs());
        bb.put((byte)ServerStatsFieldEnums.Id.SERVER_STATS_TRACE_OPTION_ID.value());
        bb.put(stats.getTraceOption());
        return bb.array();
    }

    public static ServerStats parseBytes(byte[] serialized) throws ServerStatsDeserializationException {
        ByteBuffer bb = ByteBuffer.wrap(serialized);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        long serviceLatencyNs = 0L;
        long lbLatencyNs = 0L;
        byte traceOption = 0;
        if (!bb.hasRemaining()) {
            throw new ServerStatsDeserializationException("Serialized ServerStats buffer is empty");
        }
        byte version = bb.get();
        if (version > 0 || version < 0) {
            throw new ServerStatsDeserializationException(new StringBuilder(33).append("Invalid ServerStats version: ").append(version).toString());
        }
        while (bb.hasRemaining()) {
            ServerStatsFieldEnums.Id id = ServerStatsFieldEnums.Id.valueOf(bb.get() & 0xFF);
            if (id == null) {
                bb.position(bb.limit());
                continue;
            }
            switch (id) {
                case SERVER_STATS_LB_LATENCY_ID: {
                    lbLatencyNs = bb.getLong();
                    break;
                }
                case SERVER_STATS_SERVICE_LATENCY_ID: {
                    serviceLatencyNs = bb.getLong();
                    break;
                }
                case SERVER_STATS_TRACE_OPTION_ID: {
                    traceOption = bb.get();
                }
            }
        }
        try {
            return ServerStats.create(lbLatencyNs, serviceLatencyNs, traceOption);
        }
        catch (IllegalArgumentException e) {
            String string = String.valueOf(e.getMessage());
            throw new ServerStatsDeserializationException(string.length() != 0 ? "Serialized ServiceStats contains invalid values: ".concat(string) : new String("Serialized ServiceStats contains invalid values: "));
        }
    }
}

