/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.impl.tags;

import com.google.common.annotations.VisibleForTesting;
import io.opencensus.common.Scope;
import io.opencensus.internal.NoopScope;
import io.opencensus.internal.Utils;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagMetadata;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.TaggingState;
import io.opencensus.tags.TagsComponent;
import io.opencensus.tags.propagation.TagContextBinarySerializer;
import io.opencensus.tags.propagation.TagContextDeserializationException;
import io.opencensus.tags.propagation.TagContextSerializationException;
import io.opencensus.tags.propagation.TagContextTextFormat;
import io.opencensus.tags.propagation.TagPropagationComponent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

public final class NoopTags {
    private NoopTags() {
    }

    public static TagsComponent newNoopTagsComponent() {
        return new NoopTagsComponent();
    }

    public static Tagger getNoopTagger() {
        return NoopTagger.INSTANCE;
    }

    public static TagContextBuilder getNoopTagContextBuilder() {
        return NoopTagContextBuilder.INSTANCE;
    }

    public static TagContext getNoopTagContext() {
        return NoopTagContext.INSTANCE;
    }

    public static TagPropagationComponent getNoopTagPropagationComponent() {
        return NoopTagPropagationComponent.INSTANCE;
    }

    public static TagContextBinarySerializer getNoopTagContextBinarySerializer() {
        return NoopTagContextBinarySerializer.INSTANCE;
    }

    public static TagContextTextFormat getNoopTagContextTextSerializer() {
        return NoopTagContextTextFormat.INSTANCE;
    }

    @Immutable
    private static final class NoopTagContextTextFormat
    extends TagContextTextFormat {
        static final NoopTagContextTextFormat INSTANCE = new NoopTagContextTextFormat();

        private NoopTagContextTextFormat() {
        }

        @Override
        public List<String> fields() {
            return Collections.emptyList();
        }

        @Override
        public <C> void inject(TagContext tagContext, C carrier, TagContextTextFormat.Setter<C> setter) throws TagContextSerializationException {
            Utils.checkNotNull(tagContext, "tagContext");
            Utils.checkNotNull(carrier, "carrier");
            Utils.checkNotNull(setter, "setter");
        }

        @Override
        public <C> TagContext extract(C carrier, TagContextTextFormat.Getter<C> getter) throws TagContextDeserializationException {
            Utils.checkNotNull(carrier, "carrier");
            Utils.checkNotNull(getter, "getter");
            return NoopTags.getNoopTagContext();
        }
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.PRIVATE)
    @Immutable
    public static final class NoopTagContextBinarySerializer
    extends TagContextBinarySerializer {
        static final TagContextBinarySerializer INSTANCE = new NoopTagContextBinarySerializer();
        static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

        @Override
        public byte[] toByteArray(TagContext tags) {
            Utils.checkNotNull(tags, "tags");
            return EMPTY_BYTE_ARRAY;
        }

        @Override
        public TagContext fromByteArray(byte[] bytes) {
            Utils.checkNotNull(bytes, "bytes");
            return NoopTags.getNoopTagContext();
        }
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.PRIVATE)
    @Immutable
    public static final class NoopTagPropagationComponent
    extends TagPropagationComponent {
        static final TagPropagationComponent INSTANCE = new NoopTagPropagationComponent();

        @Override
        public TagContextBinarySerializer getBinarySerializer() {
            return NoopTags.getNoopTagContextBinarySerializer();
        }

        @Override
        public TagContextTextFormat getCorrelationContextFormat() {
            return NoopTags.getNoopTagContextTextSerializer();
        }
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.PRIVATE)
    @Immutable
    public static final class NoopTagContext
    extends TagContext {
        static final TagContext INSTANCE = new NoopTagContext();

        @Override
        protected Iterator<Tag> getIterator() {
            return Collections.emptySet().iterator();
        }
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.PRIVATE)
    @Immutable
    public static final class NoopTagContextBuilder
    extends TagContextBuilder {
        static final TagContextBuilder INSTANCE = new NoopTagContextBuilder();

        @Override
        public TagContextBuilder put(TagKey key, TagValue value) {
            Utils.checkNotNull(key, "key");
            Utils.checkNotNull(value, "value");
            return this;
        }

        @Override
        public TagContextBuilder put(TagKey key, TagValue value, TagMetadata tagMetadata) {
            Utils.checkNotNull(key, "key");
            Utils.checkNotNull(value, "value");
            Utils.checkNotNull(tagMetadata, "tagMetadata");
            return this;
        }

        @Override
        public TagContextBuilder remove(TagKey key) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public TagContext build() {
            return NoopTags.getNoopTagContext();
        }

        @Override
        public Scope buildScoped() {
            return NoopScope.getInstance();
        }
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.PRIVATE)
    @Immutable
    public static final class NoopTagger
    extends Tagger {
        static final Tagger INSTANCE = new NoopTagger();

        @Override
        public TagContext empty() {
            return NoopTags.getNoopTagContext();
        }

        @Override
        public TagContext getCurrentTagContext() {
            return NoopTags.getNoopTagContext();
        }

        @Override
        public TagContextBuilder emptyBuilder() {
            return NoopTags.getNoopTagContextBuilder();
        }

        @Override
        public TagContextBuilder toBuilder(TagContext tags) {
            Utils.checkNotNull(tags, "tags");
            return NoopTags.getNoopTagContextBuilder();
        }

        @Override
        public TagContextBuilder currentBuilder() {
            return NoopTags.getNoopTagContextBuilder();
        }

        @Override
        public Scope withTagContext(TagContext tags) {
            Utils.checkNotNull(tags, "tags");
            return NoopScope.getInstance();
        }
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.PRIVATE)
    @ThreadSafe
    public static final class NoopTagsComponent
    extends TagsComponent {
        private volatile boolean isRead;

        @Override
        public Tagger getTagger() {
            return NoopTags.getNoopTagger();
        }

        @Override
        public TagPropagationComponent getTagPropagationComponent() {
            return NoopTags.getNoopTagPropagationComponent();
        }

        @Override
        public TaggingState getState() {
            this.isRead = true;
            return TaggingState.DISABLED;
        }

        @Override
        @Deprecated
        public void setState(TaggingState state) {
            Utils.checkNotNull(state, "state");
            Utils.checkState(!this.isRead, "State was already read, cannot set state.");
        }
    }
}

