/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.metrics.export;

import io.opencensus.metrics.export.Distribution;
import java.util.List;
import javax.annotation.Nullable;

final class AutoValue_Distribution
extends Distribution {
    private final long count;
    private final double sum;
    private final double sumOfSquaredDeviations;
    private final Distribution.BucketOptions bucketOptions;
    private final List<Distribution.Bucket> buckets;

    AutoValue_Distribution(long count, double sum, double sumOfSquaredDeviations, @Nullable Distribution.BucketOptions bucketOptions, List<Distribution.Bucket> buckets) {
        this.count = count;
        this.sum = sum;
        this.sumOfSquaredDeviations = sumOfSquaredDeviations;
        this.bucketOptions = bucketOptions;
        if (buckets == null) {
            throw new NullPointerException("Null buckets");
        }
        this.buckets = buckets;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public double getSumOfSquaredDeviations() {
        return this.sumOfSquaredDeviations;
    }

    @Override
    @Nullable
    public Distribution.BucketOptions getBucketOptions() {
        return this.bucketOptions;
    }

    @Override
    public List<Distribution.Bucket> getBuckets() {
        return this.buckets;
    }

    public String toString() {
        long l = this.count;
        double d = this.sum;
        double d2 = this.sumOfSquaredDeviations;
        String string = String.valueOf(this.bucketOptions);
        String string2 = String.valueOf(this.buckets);
        return new StringBuilder(145 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Distribution{count=").append(l).append(", sum=").append(d).append(", sumOfSquaredDeviations=").append(d2).append(", bucketOptions=").append(string).append(", buckets=").append(string2).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Distribution) {
            Distribution that = (Distribution)o;
            return this.count == that.getCount() && Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(that.getSum()) && Double.doubleToLongBits(this.sumOfSquaredDeviations) == Double.doubleToLongBits(that.getSumOfSquaredDeviations()) && (this.bucketOptions == null ? that.getBucketOptions() == null : this.bucketOptions.equals(that.getBucketOptions())) && this.buckets.equals(that.getBuckets());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.count >>> 32 ^ this.count);
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.sum) >>> 32 ^ Double.doubleToLongBits(this.sum));
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.sumOfSquaredDeviations) >>> 32 ^ Double.doubleToLongBits(this.sumOfSquaredDeviations));
        h$ *= 1000003;
        h$ ^= this.bucketOptions == null ? 0 : this.bucketOptions.hashCode();
        h$ *= 1000003;
        return h$ ^= this.buckets.hashCode();
    }
}

