/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.tags;

import com.google.auto.value.AutoValue;
import io.opencensus.internal.StringUtils;
import io.opencensus.internal.Utils;
import io.opencensus.tags.AutoValue_TagValue;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class TagValue {
    public static final int MAX_LENGTH = 255;

    TagValue() {
    }

    public static TagValue create(String value) {
        Utils.checkArgument(TagValue.isValid(value), "Invalid TagValue: %s", value);
        return new AutoValue_TagValue(value);
    }

    public abstract String asString();

    private static boolean isValid(String value) {
        return value.length() <= 255 && StringUtils.isPrintableString(value);
    }
}

