/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace.config;

import io.opencensus.trace.Sampler;
import io.opencensus.trace.config.TraceParams;

final class AutoValue_TraceParams
extends TraceParams {
    private final Sampler sampler;
    private final int maxNumberOfAttributes;
    private final int maxNumberOfAnnotations;
    private final int maxNumberOfMessageEvents;
    private final int maxNumberOfLinks;

    private AutoValue_TraceParams(Sampler sampler, int maxNumberOfAttributes, int maxNumberOfAnnotations, int maxNumberOfMessageEvents, int maxNumberOfLinks) {
        this.sampler = sampler;
        this.maxNumberOfAttributes = maxNumberOfAttributes;
        this.maxNumberOfAnnotations = maxNumberOfAnnotations;
        this.maxNumberOfMessageEvents = maxNumberOfMessageEvents;
        this.maxNumberOfLinks = maxNumberOfLinks;
    }

    @Override
    public Sampler getSampler() {
        return this.sampler;
    }

    @Override
    public int getMaxNumberOfAttributes() {
        return this.maxNumberOfAttributes;
    }

    @Override
    public int getMaxNumberOfAnnotations() {
        return this.maxNumberOfAnnotations;
    }

    @Override
    public int getMaxNumberOfMessageEvents() {
        return this.maxNumberOfMessageEvents;
    }

    @Override
    public int getMaxNumberOfLinks() {
        return this.maxNumberOfLinks;
    }

    public String toString() {
        String string = String.valueOf(this.sampler);
        int n = this.maxNumberOfAttributes;
        int n2 = this.maxNumberOfAnnotations;
        int n3 = this.maxNumberOfMessageEvents;
        int n4 = this.maxNumberOfLinks;
        return new StringBuilder(160 + String.valueOf(string).length()).append("TraceParams{sampler=").append(string).append(", maxNumberOfAttributes=").append(n).append(", maxNumberOfAnnotations=").append(n2).append(", maxNumberOfMessageEvents=").append(n3).append(", maxNumberOfLinks=").append(n4).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TraceParams) {
            TraceParams that = (TraceParams)o;
            return this.sampler.equals(that.getSampler()) && this.maxNumberOfAttributes == that.getMaxNumberOfAttributes() && this.maxNumberOfAnnotations == that.getMaxNumberOfAnnotations() && this.maxNumberOfMessageEvents == that.getMaxNumberOfMessageEvents() && this.maxNumberOfLinks == that.getMaxNumberOfLinks();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.sampler.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxNumberOfAttributes;
        h$ *= 1000003;
        h$ ^= this.maxNumberOfAnnotations;
        h$ *= 1000003;
        h$ ^= this.maxNumberOfMessageEvents;
        h$ *= 1000003;
        return h$ ^= this.maxNumberOfLinks;
    }

    @Override
    public TraceParams.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TraceParams.Builder {
        private Sampler sampler;
        private Integer maxNumberOfAttributes;
        private Integer maxNumberOfAnnotations;
        private Integer maxNumberOfMessageEvents;
        private Integer maxNumberOfLinks;

        Builder() {
        }

        private Builder(TraceParams source) {
            this.sampler = source.getSampler();
            this.maxNumberOfAttributes = source.getMaxNumberOfAttributes();
            this.maxNumberOfAnnotations = source.getMaxNumberOfAnnotations();
            this.maxNumberOfMessageEvents = source.getMaxNumberOfMessageEvents();
            this.maxNumberOfLinks = source.getMaxNumberOfLinks();
        }

        @Override
        public TraceParams.Builder setSampler(Sampler sampler) {
            if (sampler == null) {
                throw new NullPointerException("Null sampler");
            }
            this.sampler = sampler;
            return this;
        }

        @Override
        public TraceParams.Builder setMaxNumberOfAttributes(int maxNumberOfAttributes) {
            this.maxNumberOfAttributes = maxNumberOfAttributes;
            return this;
        }

        @Override
        public TraceParams.Builder setMaxNumberOfAnnotations(int maxNumberOfAnnotations) {
            this.maxNumberOfAnnotations = maxNumberOfAnnotations;
            return this;
        }

        @Override
        public TraceParams.Builder setMaxNumberOfMessageEvents(int maxNumberOfMessageEvents) {
            this.maxNumberOfMessageEvents = maxNumberOfMessageEvents;
            return this;
        }

        @Override
        public TraceParams.Builder setMaxNumberOfLinks(int maxNumberOfLinks) {
            this.maxNumberOfLinks = maxNumberOfLinks;
            return this;
        }

        @Override
        TraceParams autoBuild() {
            String missing = "";
            if (this.sampler == null) {
                missing = String.valueOf(missing).concat(" sampler");
            }
            if (this.maxNumberOfAttributes == null) {
                missing = String.valueOf(missing).concat(" maxNumberOfAttributes");
            }
            if (this.maxNumberOfAnnotations == null) {
                missing = String.valueOf(missing).concat(" maxNumberOfAnnotations");
            }
            if (this.maxNumberOfMessageEvents == null) {
                missing = String.valueOf(missing).concat(" maxNumberOfMessageEvents");
            }
            if (this.maxNumberOfLinks == null) {
                missing = String.valueOf(missing).concat(" maxNumberOfLinks");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_TraceParams(this.sampler, this.maxNumberOfAttributes, this.maxNumberOfAnnotations, this.maxNumberOfMessageEvents, this.maxNumberOfLinks);
        }
    }
}

