/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark;

import com.google.errorprone.annotations.CompileTimeConstant;
import com.google.errorprone.annotations.DoNotCall;
import io.perfmark.Impl;
import io.perfmark.Link;
import io.perfmark.Tag;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PerfMark {
    private static final Impl impl;

    public static void setEnabled(boolean value) {
        impl.setEnabled(value);
    }

    public static void startTask(@CompileTimeConstant String taskName, Tag tag) {
        impl.startTask(taskName, tag);
    }

    public static void startTask(@CompileTimeConstant String taskName) {
        impl.startTask(taskName);
    }

    public static void event(@CompileTimeConstant String eventName, Tag tag) {
        impl.event(eventName, tag);
    }

    public static void event(@CompileTimeConstant String eventName) {
        impl.event(eventName);
    }

    public static void stopTask(@CompileTimeConstant String taskName, Tag tag) {
        impl.stopTask(taskName, tag);
    }

    public static void stopTask(@CompileTimeConstant String taskName) {
        impl.stopTask(taskName);
    }

    public static Tag createTag() {
        return Impl.NO_TAG;
    }

    public static Tag createTag(long id) {
        return impl.createTag("", id);
    }

    public static Tag createTag(String name) {
        return impl.createTag(name, Long.MIN_VALUE);
    }

    public static Tag createTag(String name, long id) {
        return impl.createTag(name, id);
    }

    @Deprecated
    @DoNotCall
    public static Link link() {
        return Impl.NO_LINK;
    }

    public static Link linkOut() {
        return impl.linkOut();
    }

    public static void linkIn(Link link) {
        impl.linkIn(link);
    }

    private PerfMark() {
    }

    static {
        Impl instance = null;
        Level level = Level.WARNING;
        Throwable err = null;
        Class<?> clz = null;
        try {
            clz = Class.forName("io.perfmark.impl.SecretPerfMarkImpl$PerfMarkImpl");
        }
        catch (ClassNotFoundException e) {
            level = Level.FINE;
            err = e;
        }
        catch (Throwable t) {
            err = t;
        }
        if (clz != null) {
            try {
                instance = clz.asSubclass(Impl.class).getConstructor(Tag.class).newInstance(Impl.NO_TAG);
            }
            catch (Throwable t) {
                err = t;
            }
        }
        impl = instance != null ? instance : new Impl(Impl.NO_TAG);
        if (err != null) {
            Logger.getLogger(PerfMark.class.getName()).logp(level, "io.perfmark.PerfMark", "<clinit>", "Error during PerfMark.<clinit>", err);
        }
    }
}

