/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.MarkHolderProvider;
import io.perfmark.impl.MarkList;
import io.perfmark.impl.Marker;
import io.perfmark.impl.NoopMarkHolderProvider;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class Storage {
    private static final long INIT_NANO_TIME = System.nanoTime();
    static final ConcurrentMap<MarkHolderRef, Boolean> allMarkHolders = new ConcurrentHashMap<MarkHolderRef, Boolean>();
    private static final ThreadLocal<MarkHolder> localMarkHolder = new MarkHolderThreadLocal();
    static final MarkHolderProvider markHolderProvider;
    private static final Logger logger;

    public static long getInitNanoTime() {
        return INIT_NANO_TIME;
    }

    public static List<MarkList> read() {
        ArrayList markHolderRefs = new ArrayList();
        MarkHolderRef.cleanQueue(markHolderRefs, allMarkHolders);
        markHolderRefs.addAll(allMarkHolders.keySet());
        ArrayList markLists = new ArrayList(markHolderRefs.size());
        Storage.readInto(markLists, markHolderRefs);
        return Collections.unmodifiableList(markLists);
    }

    private static void readInto(List<? super MarkList> markLists, List<? extends MarkHolderRef> markHolderRefs) {
        for (MarkHolderRef markHolderRef : markHolderRefs) {
            String threadName;
            Thread writer = (Thread)markHolderRef.get();
            if (writer != null) {
                threadName = writer.getName();
                markHolderRef.lastThreadName.set(threadName);
            } else {
                threadName = markHolderRef.lastThreadName.get();
            }
            boolean concurrentWrites = Thread.currentThread() != writer && writer != null;
            markLists.add(MarkList.newBuilder().setMarks(markHolderRef.holder.read(concurrentWrites)).setThreadName(threadName).setThreadId(markHolderRef.threadId).setMarkListId(markHolderRef.markHolderId).build());
        }
    }

    static void startAnyways(long gen, String taskName, @Nullable String tagName, long tagId) {
        localMarkHolder.get().start(gen, taskName, tagName, tagId, System.nanoTime());
    }

    static void startAnyways(long gen, String taskName, Marker marker, @Nullable String tagName, long tagId) {
        localMarkHolder.get().start(gen, taskName, marker, tagName, tagId, System.nanoTime());
    }

    static void startAnyways(long gen, String taskName) {
        localMarkHolder.get().start(gen, taskName, System.nanoTime());
    }

    static void startAnyways(long gen, String taskName, Marker marker) {
        localMarkHolder.get().start(gen, taskName, marker, System.nanoTime());
    }

    static void stopAnyways(long gen, String taskName, @Nullable String tagName, long tagId) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().stop(gen, taskName, tagName, tagId, nanoTime);
    }

    static void stopAnyways(long gen, String taskName, Marker marker, @Nullable String tagName, long tagId) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().stop(gen, taskName, marker, tagName, tagId, nanoTime);
    }

    static void stopAnyways(long gen, String taskName) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().stop(gen, taskName, nanoTime);
    }

    static void stopAnyways(long gen, String taskName, Marker marker) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().stop(gen, taskName, marker, nanoTime);
    }

    static void eventAnyways(long gen, String eventName, @Nullable String tagName, long tagId) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().event(gen, eventName, tagName, tagId, nanoTime, 0L);
    }

    static void eventAnyways(long gen, String taskName, Marker marker, @Nullable String tagName, long tagId) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().event(gen, taskName, marker, tagName, tagId, nanoTime, 0L);
    }

    static void eventAnyways(long gen, String eventName) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().event(gen, eventName, nanoTime, 0L);
    }

    static void eventAnyways(long gen, String taskName, Marker marker) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().event(gen, taskName, marker, nanoTime, 0L);
    }

    static void linkAnyways(long gen, long linkId) {
        localMarkHolder.get().link(gen, linkId);
    }

    static void linkAnyways(long gen, long linkId, Marker marker) {
        localMarkHolder.get().link(gen, linkId, marker);
    }

    public static void resetForTest() {
        localMarkHolder.remove();
    }

    @Nullable
    public static MarkList readForTest() {
        MarkHolder mh = localMarkHolder.get();
        for (MarkHolderRef ref : allMarkHolders.keySet()) {
            if (ref.holder != mh) continue;
            ArrayList markHolders = new ArrayList(1);
            Storage.readInto(markHolders, Collections.singletonList(ref));
            return (MarkList)markHolders.get(0);
        }
        return null;
    }

    private Storage() {
        throw new AssertionError((Object)"nope");
    }

    static {
        ArrayList<MarkHolderProvider> providers = new ArrayList<MarkHolderProvider>();
        ArrayList<ClassNotFoundException> fines = new ArrayList<ClassNotFoundException>();
        ArrayList<Throwable> warnings = new ArrayList<Throwable>();
        Class<?> clz = null;
        try {
            clz = Class.forName("io.perfmark.java9.SecretVarHandleMarkHolderProvider$VarHandleMarkHolderProvider");
        }
        catch (ClassNotFoundException e) {
            fines.add(e);
        }
        catch (Throwable t) {
            warnings.add(t);
        }
        if (clz != null) {
            try {
                providers.add(clz.asSubclass(MarkHolderProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable t) {
                warnings.add(t);
            }
            clz = null;
        }
        try {
            clz = Class.forName("io.perfmark.java6.SecretSynchronizedMarkHolderProvider$SynchronizedMarkHolderProvider");
        }
        catch (ClassNotFoundException e) {
            fines.add(e);
        }
        catch (Throwable t) {
            warnings.add(t);
        }
        if (clz != null) {
            try {
                providers.add(clz.asSubclass(MarkHolderProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable t) {
                warnings.add(t);
            }
            clz = null;
        }
        markHolderProvider = !providers.isEmpty() ? (MarkHolderProvider)providers.get(0) : new NoopMarkHolderProvider();
        logger = Logger.getLogger(Storage.class.getName());
        for (Throwable throwable : warnings) {
            logger.logp(Level.WARNING, "io.perfmark.impl.Storage", "<clinit>", "Error loading MarkHolderProvider", throwable);
        }
        for (Throwable throwable : fines) {
            logger.logp(Level.FINE, "io.perfmark.impl.Storage", "<clinit>", "Error loading MarkHolderProvider", throwable);
        }
    }

    private static final class MarkHolderRef
    extends WeakReference<Thread> {
        private static final ReferenceQueue<Thread> markHolderRefQueue = new ReferenceQueue();
        private static final AtomicLong markHolderIdAllocator = new AtomicLong();
        final MarkHolder holder;
        final long markHolderId = markHolderIdAllocator.incrementAndGet();
        final long threadId;
        final AtomicReference<String> lastThreadName;

        MarkHolderRef(Thread thread, MarkHolder holder) {
            super(thread, markHolderRefQueue);
            this.holder = holder;
            this.threadId = thread.getId();
            this.lastThreadName = new AtomicReference<String>(thread.getName());
        }

        static void cleanQueue(@Nullable Collection<? super MarkHolderRef> deadRefs, Map<?, ?> allSpans) {
            MarkHolderRef ref;
            while ((ref = (MarkHolderRef)markHolderRefQueue.poll()) != null) {
                ref.clear();
                allSpans.remove(ref);
                if (deadRefs == null) continue;
                deadRefs.add(ref);
            }
        }
    }

    private static final class MarkHolderThreadLocal
    extends ThreadLocal<MarkHolder> {
        MarkHolderThreadLocal() {
        }

        @Override
        protected MarkHolder initialValue() {
            MarkHolderRef.cleanQueue(null, allMarkHolders);
            MarkHolder holder = markHolderProvider.create();
            MarkHolderRef ref = new MarkHolderRef(Thread.currentThread(), holder);
            allMarkHolders.put(ref, Boolean.TRUE);
            return holder;
        }
    }
}

