/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.tracewriter;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.annotations.SerializedName;
import io.perfmark.impl.Mark;
import io.perfmark.impl.MarkList;
import io.perfmark.impl.Storage;
import io.perfmark.tracewriter.MarkListWalker;
import io.perfmark.tracewriter.TraceEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;

public final class TraceEventWriter {
    private static final Logger logger = Logger.getLogger(TraceEventWriter.class.getName());

    @CanIgnoreReturnValue
    public static Path writeTraceEvents() throws IOException {
        Path p = TraceEventWriter.pickNextDest(TraceEventWriter.guessDirectory());
        try (OutputStream os = Files.newOutputStream(p, new OpenOption[0]);
             GZIPOutputStream gzos = new GZIPOutputStream(os);){
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)gzos, StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                TraceEventWriter.writeTraceEvents(osw);
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    TraceEventWriter.$closeResource(throwable, osw);
                    throw throwable3;
                }
            }
            TraceEventWriter.$closeResource(throwable, osw);
        }
        String string = String.valueOf(p);
        logger.logp(Level.INFO, "io.perfmark.tracewriter.TraceEventWriter", "writeTraceEvents", new StringBuilder(15 + String.valueOf(string).length()).append("Wrote trace to ").append(string).toString());
        return p;
    }

    public static void writeTraceEvents(Writer destination) throws IOException {
        TraceEventWriter.writeTraceEvents(destination, Storage.read(), Storage.getInitNanoTime(), System.nanoTime(), TraceEventWriter.getPid());
    }

    public static void writeTraceEvents(Writer destination, List<? extends MarkList> markLists, long initNanoTime, long nowNanoTime, long pid) throws IOException {
        ArrayList<TraceEvent> traceEvents = new ArrayList<TraceEvent>();
        new TraceEventWalker(traceEvents, pid, initNanoTime).walk(markLists, nowNanoTime);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            gson.toJson((Object)new TraceEventObject(traceEvents), (Appendable)destination);
        }
        catch (JsonIOException e) {
            throw new IOException(e);
        }
    }

    private static Path pickNextDest(Path dir) throws IOException {
        int lo;
        String fmt = "perfmark-trace-%03d.json.gz";
        int hi = 0;
        while (true) {
            Path candidate;
            if (!Files.exists(candidate = dir.resolve(String.format(fmt, hi)), new LinkOption[0])) {
                lo = hi >>> 1;
                break;
            }
            if (hi == 0) {
                ++hi;
                continue;
            }
            if (hi >>> 1 >= Integer.MAX_VALUE) {
                throw new IOException("too many files in dir");
            }
            hi <<= 1;
        }
        while (hi > lo) {
            int mid = hi + lo >>> 1;
            Path candidate = dir.resolve(String.format(fmt, mid));
            if (Files.exists(candidate, new LinkOption[0])) {
                lo = mid + 1;
                continue;
            }
            hi = mid;
        }
        return dir.resolve(String.format(fmt, hi));
    }

    private static Path guessDirectory() throws IOException {
        String home;
        String PERFMARK_TRACE_DIR = "perfmark";
        String sep = File.separator;
        ArrayList<Path> dataHomeChoices = new ArrayList<Path>();
        String dataHome = System.getenv("XDG_DATA_HOME");
        if (dataHome != null) {
            dataHomeChoices.add(new File(new StringBuilder(8 + String.valueOf(dataHome).length() + String.valueOf(sep).length()).append(dataHome).append(sep).append("perfmark").toString()).toPath());
        }
        if ((home = System.getProperty("user.home")) != null) {
            dataHomeChoices.add(new File(new StringBuilder(19 + String.valueOf(home).length() + String.valueOf(sep).length() + String.valueOf(sep).length() + String.valueOf(sep).length()).append(home).append(sep).append(".local").append(sep).append("share").append(sep).append("perfmark").toString()).toPath());
        }
        for (Path path : dataHomeChoices) {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            } else if (!Files.isDirectory(path, new LinkOption[0])) continue;
            return path;
        }
        return new File(".").toPath();
    }

    private static Map<String, ?> tagArgs(@Nullable String tagName, long tagId) {
        LinkedHashMap<String, Object> tagMap = new LinkedHashMap<String, Object>(2);
        if (tagName != null && !tagName.equals("")) {
            tagMap.put("tag", tagName);
        }
        if (tagId != Long.MIN_VALUE) {
            tagMap.put("id", tagId);
        }
        return Collections.unmodifiableMap(tagMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getPid() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>(0);
        Level level = Level.FINE;
        try {
            Class<?> clz = Class.forName("java.lang.ProcessHandle");
            Method currentMethod = clz.getMethod("current", new Class[0]);
            Object processHandle = currentMethod.invoke(null, new Object[0]);
            Method pidMethod = clz.getMethod("pid", new Class[0]);
            long l = (Long)pidMethod.invoke(processHandle, new Object[0]);
            return l;
        }
        catch (Error | Exception e) {
            errors.add(e);
            try {
                String name = ManagementFactory.getRuntimeMXBean().getName();
                int index = name.indexOf(64);
                if (index != -1) {
                    long l = Long.parseLong(name.substring(0, index));
                    return l;
                }
            }
            catch (Error | Exception e2) {
                errors.add(e2);
            }
            level = Level.WARNING;
            return (long)level;
        }
        finally {
            for (Throwable error : errors) {
                logger.logp(level, "io.perfmark.tracewriter.TraceEventWriter", "getPid", "Error getting pid", error);
            }
        }
    }

    private static final class TraceEventWalker
    extends MarkListWalker {
        private long uniqueLinkPairId = 1L;
        private long currentThreadId = -1L;
        private long currentMarkListId = -1L;
        private final Deque<Mark> taskStack = new ArrayDeque<Mark>();
        private final Map<Long, LinkTuple> linkIdToLinkOut = new LinkedHashMap<Long, LinkTuple>();
        private final List<LinkTuple> linkIdToLinkIn = new ArrayList<LinkTuple>();
        private final long pid;
        private final long initNanoTime;
        private final List<? super TraceEvent> traceEvents;

        TraceEventWalker(List<? super TraceEvent> traceEvents, long pid, long initNanoTime) {
            this.pid = pid;
            this.initNanoTime = initNanoTime;
            this.traceEvents = traceEvents;
        }

        @Override
        protected void enterGeneration(long generation) {
            this.linkIdToLinkOut.clear();
            this.linkIdToLinkIn.clear();
        }

        @Override
        protected void exitGeneration() {
            for (LinkTuple linkIn : this.linkIdToLinkIn) {
                long localUniqueLinkPairId;
                long inLinkId = linkIn.link.getLinkId();
                long outLinkId = -inLinkId;
                LinkTuple linkOut = this.linkIdToLinkOut.get(outLinkId);
                if (linkOut == null) continue;
                if (linkOut.markListId == linkIn.markListId) {
                    // empty if block
                }
                String string = linkOut.lastTaskStart.getTaskName();
                String string2 = linkIn.lastTaskStart.getTaskName();
                String name = new StringBuilder(10 + String.valueOf(string).length() + String.valueOf(string2).length()).append("link(").append(string).append(" -> ").append(string2).append(")").toString();
                ++this.uniqueLinkPairId;
                this.traceEvents.add(TraceEvent.EVENT.name(name).tid(linkOut.threadId).pid(this.pid).phase("s").id(localUniqueLinkPairId).arg("linkid", linkOut.link.getLinkId()).traceClockNanos(linkOut.lastTaskStart.getNanoTime() - this.initNanoTime));
                this.traceEvents.add(TraceEvent.EVENT.name(name).tid(linkIn.threadId).pid(this.pid).phase("t").id(localUniqueLinkPairId).arg("linkid", linkOut.link.getLinkId()).traceClockNanos(linkIn.lastTaskStart.getNanoTime() - this.initNanoTime));
            }
            super.exitGeneration();
        }

        @Override
        protected void enterMarkList(String threadName, long threadId, long markListId) {
            this.currentThreadId = threadId;
            this.currentMarkListId = markListId;
            this.traceEvents.add(TraceEvent.EVENT.name("thread_name").phase("M").pid(this.pid).arg("name", threadName).arg("markListId", markListId).tid(this.currentThreadId));
        }

        @Override
        protected void onTaskStart(Mark mark, boolean unmatchedStart, boolean unmatchedEnd) {
            assert (!unmatchedStart || !unmatchedEnd);
            List<String> categories = Collections.emptyList();
            if (unmatchedStart) {
                categories = Collections.singletonList("unknownStart");
            } else if (unmatchedEnd) {
                categories = Collections.singletonList("unfinished");
            }
            this.taskStack.add(mark);
            this.traceEvents.add(TraceEvent.EVENT.name(mark.getTaskName()).phase("B").pid(this.pid).args(TraceEventWriter.tagArgs(mark.getTagName(), mark.getTagId())).categories(categories).tid(this.currentThreadId).traceClockNanos(mark.getNanoTime() - this.initNanoTime));
        }

        @Override
        protected void onTaskEnd(Mark mark, boolean unmatchedStart, boolean unmatchedEnd) {
            assert (!unmatchedStart || !unmatchedEnd);
            List<String> categories = Collections.emptyList();
            if (unmatchedStart) {
                categories = Collections.singletonList("unknownStart");
            } else if (unmatchedEnd) {
                categories = Collections.singletonList("unfinished");
            }
            this.taskStack.pollLast();
            this.traceEvents.add(TraceEvent.EVENT.name(mark.getTaskName()).phase("E").pid(this.pid).args(TraceEventWriter.tagArgs(mark.getTagName(), mark.getTagId())).categories(categories).tid(this.currentThreadId).traceClockNanos(mark.getNanoTime() - this.initNanoTime));
        }

        @Override
        protected void onEvent(Mark mark) {
            this.traceEvents.add(TraceEvent.EVENT.name(mark.getTaskName()).phase("i").pid(this.pid).args(TraceEventWriter.tagArgs(mark.getTagName(), mark.getTagId())).tid(this.currentThreadId).traceClockNanos(mark.getNanoTime() - this.initNanoTime));
        }

        @Override
        protected void onLink(Mark mark) {
            if (this.taskStack.isEmpty()) {
                logger.logp(Level.WARNING, "io.perfmark.tracewriter.TraceEventWriter$TraceEventWalker", "onLink", "Link not associated with any task");
                return;
            }
            LinkTuple linkTuple = new LinkTuple(this.taskStack.peekLast(), mark, this.currentThreadId, this.currentMarkListId);
            if (mark.getLinkId() > 0L) {
                LinkTuple old = this.linkIdToLinkOut.put(mark.getLinkId(), linkTuple);
                assert (old == null);
            } else if (mark.getLinkId() < 0L) {
                this.linkIdToLinkIn.add(linkTuple);
            }
        }

        static final class LinkTuple {
            final Mark lastTaskStart;
            final Mark link;
            final long threadId;
            final long markListId;

            LinkTuple(Mark lastTaskStart, Mark link, long threadId, long markListId) {
                this.lastTaskStart = lastTaskStart;
                this.link = link;
                this.threadId = threadId;
                this.markListId = markListId;
            }
        }
    }

    static final class TraceEventObject {
        @SerializedName(value="traceEvents")
        final List<TraceEvent> traceEvents;
        @SerializedName(value="displayTimeUnit")
        final String displayTimeUnit = "ns";
        @SerializedName(value="systemTraceEvents")
        final String systemTraceData = "";
        @SerializedName(value="samples")
        final List<Object> samples = new ArrayList<Object>();
        @SerializedName(value="stackFrames")
        final Map<String, ?> stackFrames = new HashMap();

        TraceEventObject(List<TraceEvent> traceEvents) {
            this.traceEvents = Collections.unmodifiableList(new ArrayList<TraceEvent>(traceEvents));
        }
    }
}

