/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model.util;

import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor6;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ElementKindVisitor6<R, P>
extends SimpleElementVisitor6<R, P> {
    @Deprecated
    protected ElementKindVisitor6() {
        super(null);
    }

    @Deprecated
    protected ElementKindVisitor6(R r) {
        super(r);
    }

    @Override
    public R visitPackage(PackageElement packageElement, P p) {
        assert (packageElement.getKind() == ElementKind.PACKAGE) : "Bad kind on PackageElement";
        return this.defaultAction(packageElement, p);
    }

    @Override
    public R visitType(TypeElement typeElement, P p) {
        ElementKind elementKind = typeElement.getKind();
        switch (elementKind) {
            case ANNOTATION_TYPE: {
                return this.visitTypeAsAnnotationType(typeElement, p);
            }
            case CLASS: {
                return this.visitTypeAsClass(typeElement, p);
            }
            case ENUM: {
                return this.visitTypeAsEnum(typeElement, p);
            }
            case INTERFACE: {
                return this.visitTypeAsInterface(typeElement, p);
            }
        }
        String string = String.valueOf((Object)elementKind);
        String string2 = String.valueOf(typeElement);
        throw new AssertionError((Object)new StringBuilder(25 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Bad kind ").append(string).append(" for TypeElement").append(string2).toString());
    }

    public R visitTypeAsAnnotationType(TypeElement typeElement, P p) {
        return this.defaultAction(typeElement, p);
    }

    public R visitTypeAsClass(TypeElement typeElement, P p) {
        return this.defaultAction(typeElement, p);
    }

    public R visitTypeAsEnum(TypeElement typeElement, P p) {
        return this.defaultAction(typeElement, p);
    }

    public R visitTypeAsInterface(TypeElement typeElement, P p) {
        return this.defaultAction(typeElement, p);
    }

    @Override
    public R visitVariable(VariableElement variableElement, P p) {
        ElementKind elementKind = variableElement.getKind();
        switch (elementKind) {
            case ENUM_CONSTANT: {
                return this.visitVariableAsEnumConstant(variableElement, p);
            }
            case EXCEPTION_PARAMETER: {
                return this.visitVariableAsExceptionParameter(variableElement, p);
            }
            case FIELD: {
                return this.visitVariableAsField(variableElement, p);
            }
            case LOCAL_VARIABLE: {
                return this.visitVariableAsLocalVariable(variableElement, p);
            }
            case PARAMETER: {
                return this.visitVariableAsParameter(variableElement, p);
            }
            case RESOURCE_VARIABLE: {
                return this.visitVariableAsResourceVariable(variableElement, p);
            }
        }
        String string = String.valueOf((Object)elementKind);
        String string2 = String.valueOf(variableElement);
        throw new AssertionError((Object)new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Bad kind ").append(string).append(" for VariableElement").append(string2).toString());
    }

    public R visitVariableAsEnumConstant(VariableElement variableElement, P p) {
        return this.defaultAction(variableElement, p);
    }

    public R visitVariableAsExceptionParameter(VariableElement variableElement, P p) {
        return this.defaultAction(variableElement, p);
    }

    public R visitVariableAsField(VariableElement variableElement, P p) {
        return this.defaultAction(variableElement, p);
    }

    public R visitVariableAsLocalVariable(VariableElement variableElement, P p) {
        return this.defaultAction(variableElement, p);
    }

    public R visitVariableAsParameter(VariableElement variableElement, P p) {
        return this.defaultAction(variableElement, p);
    }

    public R visitVariableAsResourceVariable(VariableElement variableElement, P p) {
        return this.visitUnknown(variableElement, p);
    }

    @Override
    public R visitExecutable(ExecutableElement executableElement, P p) {
        ElementKind elementKind = executableElement.getKind();
        switch (elementKind) {
            case CONSTRUCTOR: {
                return this.visitExecutableAsConstructor(executableElement, p);
            }
            case INSTANCE_INIT: {
                return this.visitExecutableAsInstanceInit(executableElement, p);
            }
            case METHOD: {
                return this.visitExecutableAsMethod(executableElement, p);
            }
            case STATIC_INIT: {
                return this.visitExecutableAsStaticInit(executableElement, p);
            }
        }
        String string = String.valueOf((Object)elementKind);
        String string2 = String.valueOf(executableElement);
        throw new AssertionError((Object)new StringBuilder(31 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Bad kind ").append(string).append(" for ExecutableElement").append(string2).toString());
    }

    public R visitExecutableAsConstructor(ExecutableElement executableElement, P p) {
        return this.defaultAction(executableElement, p);
    }

    public R visitExecutableAsInstanceInit(ExecutableElement executableElement, P p) {
        return this.defaultAction(executableElement, p);
    }

    public R visitExecutableAsMethod(ExecutableElement executableElement, P p) {
        return this.defaultAction(executableElement, p);
    }

    public R visitExecutableAsStaticInit(ExecutableElement executableElement, P p) {
        return this.defaultAction(executableElement, p);
    }

    @Override
    public R visitTypeParameter(TypeParameterElement typeParameterElement, P p) {
        assert (typeParameterElement.getKind() == ElementKind.TYPE_PARAMETER) : "Bad kind on TypeParameterElement";
        return this.defaultAction(typeParameterElement, p);
    }
}

