/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;

public final class Lister {
    private static final ArchiveStreamFactory factory = new ArchiveStreamFactory();

    public static void main(String[] args) throws Exception {
        String format;
        if (args.length == 0) {
            Lister.usage();
            return;
        }
        String string = String.valueOf(args[0]);
        System.out.println(string.length() != 0 ? "Analysing ".concat(string) : new String("Analysing "));
        File f = new File(args[0]);
        if (!f.isFile()) {
            String string2 = String.valueOf(f);
            System.err.println(new StringBuilder(32 + String.valueOf(string2).length()).append(string2).append(" doesn't exist or is a directory").toString());
        }
        String string3 = format = args.length > 1 ? args[1] : Lister.detectFormat(f);
        if ("7z".equalsIgnoreCase(format)) {
            Lister.list7z(f);
        } else {
            Lister.listStream(f, args);
        }
    }

    private static void listStream(File f, String[] args) throws ArchiveException, IOException {
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));
             ArchiveInputStream ais = Lister.createArchiveInputStream(args, fis);){
            ArchiveEntry ae;
            String string = String.valueOf(ais.toString());
            System.out.println(string.length() != 0 ? "Created ".concat(string) : new String("Created "));
            while ((ae = ais.getNextEntry()) != null) {
                System.out.println(ae.getName());
            }
        }
    }

    private static ArchiveInputStream createArchiveInputStream(String[] args, InputStream fis) throws ArchiveException {
        if (args.length > 1) {
            return factory.createArchiveInputStream(args[1], fis);
        }
        return factory.createArchiveInputStream(fis);
    }

    private static String detectFormat(File f) throws ArchiveException, IOException {
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));){
            String string = ArchiveStreamFactory.detect(fis);
            return string;
        }
    }

    private static void list7z(File f) throws ArchiveException, IOException {
        try (SevenZFile z = new SevenZFile(f);){
            SevenZArchiveEntry ae;
            String string = String.valueOf(z.toString());
            System.out.println(string.length() != 0 ? "Created ".concat(string) : new String("Created "));
            while ((ae = z.getNextEntry()) != null) {
                System.out.println(ae.getName());
            }
        }
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [archive-type]");
    }
}

