/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;

public class Expander {
    public void expand(File archive, File targetDirectory) throws IOException, ArchiveException {
        String format = null;
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            new ArchiveStreamFactory();
            format = ArchiveStreamFactory.detect(i);
        }
        this.expand(format, archive, targetDirectory);
    }

    public void expand(String format, File archive, File targetDirectory) throws IOException, ArchiveException {
        if (this.prefersSeekableByteChannel(format)) {
            try (FileChannel c = FileChannel.open(archive.toPath(), StandardOpenOption.READ);){
                this.expand(format, c, targetDirectory);
            }
            return;
        }
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            this.expand(format, i, targetDirectory);
        }
    }

    public void expand(InputStream archive, File targetDirectory) throws IOException, ArchiveException {
        this.expand(new ArchiveStreamFactory().createArchiveInputStream(archive), targetDirectory);
    }

    public void expand(String format, InputStream archive, File targetDirectory) throws IOException, ArchiveException {
        this.expand(new ArchiveStreamFactory().createArchiveInputStream(format, archive), targetDirectory);
    }

    public void expand(String format, SeekableByteChannel archive, File targetDirectory) throws IOException, ArchiveException {
        if (!this.prefersSeekableByteChannel(format)) {
            this.expand(format, Channels.newInputStream(archive), targetDirectory);
        } else if ("zip".equalsIgnoreCase(format)) {
            this.expand(new ZipFile(archive), targetDirectory);
        } else if ("7z".equalsIgnoreCase(format)) {
            this.expand(new SevenZFile(archive), targetDirectory);
        } else {
            String string = String.valueOf(format);
            throw new ArchiveException(string.length() != 0 ? "don't know how to handle format ".concat(string) : new String("don't know how to handle format "));
        }
    }

    public void expand(final ArchiveInputStream archive, File targetDirectory) throws IOException, ArchiveException {
        this.expand(new ArchiveEntrySupplier(this){

            @Override
            public ArchiveEntry getNextReadableEntry() throws IOException {
                ArchiveEntry next = archive.getNextEntry();
                while (next != null && !archive.canReadEntryData(next)) {
                    next = archive.getNextEntry();
                }
                return next;
            }
        }, new EntryWriter(this){

            @Override
            public void writeEntryDataTo(ArchiveEntry entry, OutputStream out) throws IOException {
                IOUtils.copy(archive, out);
            }
        }, targetDirectory);
    }

    public void expand(final ZipFile archive, File targetDirectory) throws IOException, ArchiveException {
        final Enumeration<ZipArchiveEntry> entries = archive.getEntries();
        this.expand(new ArchiveEntrySupplier(this){

            @Override
            public ArchiveEntry getNextReadableEntry() throws IOException {
                ZipArchiveEntry next;
                ZipArchiveEntry zipArchiveEntry = next = entries.hasMoreElements() ? (ZipArchiveEntry)entries.nextElement() : null;
                while (next != null && !archive.canReadEntryData(next)) {
                    next = entries.hasMoreElements() ? (ZipArchiveEntry)entries.nextElement() : null;
                }
                return next;
            }
        }, new EntryWriter(this){

            @Override
            public void writeEntryDataTo(ArchiveEntry entry, OutputStream out) throws IOException {
                try (InputStream in = archive.getInputStream((ZipArchiveEntry)entry);){
                    IOUtils.copy(in, out);
                }
            }
        }, targetDirectory);
    }

    public void expand(final SevenZFile archive, File targetDirectory) throws IOException, ArchiveException {
        this.expand(new ArchiveEntrySupplier(this){

            @Override
            public ArchiveEntry getNextReadableEntry() throws IOException {
                return archive.getNextEntry();
            }
        }, new EntryWriter(this){

            @Override
            public void writeEntryDataTo(ArchiveEntry entry, OutputStream out) throws IOException {
                byte[] buffer = new byte[8024];
                int n = 0;
                long count = 0L;
                while (-1 != (n = archive.read(buffer))) {
                    out.write(buffer, 0, n);
                    count += (long)n;
                }
            }
        }, targetDirectory);
    }

    private boolean prefersSeekableByteChannel(String format) {
        return "zip".equalsIgnoreCase(format) || "7z".equalsIgnoreCase(format);
    }

    private void expand(ArchiveEntrySupplier supplier, EntryWriter writer, File targetDirectory) throws IOException {
        String targetDirPath = targetDirectory.getCanonicalPath();
        if (!targetDirPath.endsWith(File.separator)) {
            String string = String.valueOf(targetDirPath);
            char c = File.separatorChar;
            targetDirPath = new StringBuilder(1 + String.valueOf(string).length()).append(string).append(c).toString();
        }
        ArchiveEntry nextEntry = supplier.getNextReadableEntry();
        while (nextEntry != null) {
            String string;
            String string2;
            File f = new File(targetDirectory, nextEntry.getName());
            if (!f.getCanonicalPath().startsWith(targetDirPath)) {
                string2 = nextEntry.getName();
                string = String.valueOf(targetDirectory);
                throw new IOException(new StringBuilder(40 + String.valueOf(string2).length() + String.valueOf(string).length()).append("expanding ").append(string2).append(" would create file outside of ").append(string).toString());
            }
            if (nextEntry.isDirectory()) {
                if (!f.isDirectory() && !f.mkdirs()) {
                    string2 = String.valueOf(f);
                    throw new IOException(new StringBuilder(27 + String.valueOf(string2).length()).append("failed to create directory ").append(string2).toString());
                }
            } else {
                File parent = f.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    string = String.valueOf(parent);
                    throw new IOException(new StringBuilder(27 + String.valueOf(string).length()).append("failed to create directory ").append(string).toString());
                }
                try (OutputStream o = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
                    writer.writeEntryDataTo(nextEntry, o);
                }
            }
            nextEntry = supplier.getNextReadableEntry();
        }
    }

    private static interface EntryWriter {
        public void writeEntryDataTo(ArchiveEntry var1, OutputStream var2) throws IOException;
    }

    private static interface ArchiveEntrySupplier {
        public ArchiveEntry getNextReadableEntry() throws IOException;
    }
}

