/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.util.LinkedList;
import org.apache.commons.compress.archivers.sevenz.BindPair;
import org.apache.commons.compress.archivers.sevenz.Coder;

class Folder {
    Coder[] coders;
    long totalInputStreams;
    long totalOutputStreams;
    BindPair[] bindPairs;
    long[] packedStreams;
    long[] unpackSizes;
    boolean hasCrc;
    long crc;
    int numUnpackSubStreams;

    Folder() {
    }

    Iterable<Coder> getOrderedCoders() {
        LinkedList<Coder> l = new LinkedList<Coder>();
        int current = (int)this.packedStreams[0];
        while (current != -1) {
            l.addLast(this.coders[current]);
            int pair = this.findBindPairForOutStream(current);
            current = pair != -1 ? (int)this.bindPairs[pair].inIndex : -1;
        }
        return l;
    }

    int findBindPairForInStream(int index) {
        for (int i = 0; i < this.bindPairs.length; ++i) {
            if (this.bindPairs[i].inIndex != (long)index) continue;
            return i;
        }
        return -1;
    }

    int findBindPairForOutStream(int index) {
        for (int i = 0; i < this.bindPairs.length; ++i) {
            if (this.bindPairs[i].outIndex != (long)index) continue;
            return i;
        }
        return -1;
    }

    long getUnpackSize() {
        if (this.totalOutputStreams == 0L) {
            return 0L;
        }
        for (int i = (int)this.totalOutputStreams - 1; i >= 0; --i) {
            if (this.findBindPairForOutStream(i) >= 0) continue;
            return this.unpackSizes[i];
        }
        return 0L;
    }

    long getUnpackSizeForCoder(Coder coder) {
        if (this.coders != null) {
            for (int i = 0; i < this.coders.length; ++i) {
                if (this.coders[i] != coder) continue;
                return this.unpackSizes[i];
            }
        }
        return 0L;
    }

    public String toString() {
        String string;
        int n = this.coders.length;
        long l = this.totalInputStreams;
        long l2 = this.totalOutputStreams;
        int n2 = this.bindPairs.length;
        int n3 = this.packedStreams.length;
        int n4 = this.unpackSizes.length;
        if (this.hasCrc) {
            long l3 = this.crc;
            string = new StringBuilder(29).append("with CRC ").append(l3).toString();
        } else {
            string = "without CRC";
        }
        String string2 = string;
        int n5 = this.numUnpackSubStreams;
        return new StringBuilder(214 + String.valueOf(string2).length()).append("Folder with ").append(n).append(" coders, ").append(l).append(" input streams, ").append(l2).append(" output streams, ").append(n2).append(" bind pairs, ").append(n3).append(" packed streams, ").append(n4).append(" unpack sizes, ").append(string2).append(" and ").append(n5).append(" unpack streams").toString();
    }
}

