/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.joda.convert.FromString;
import org.joda.convert.FromStringFactory;
import org.joda.convert.MethodConstructorStringConverter;
import org.joda.convert.MethodsStringConverter;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.ToString;

final class AnnotationStringConverterFactory
implements StringConverterFactory {
    static final StringConverterFactory INSTANCE = new AnnotationStringConverterFactory();

    private AnnotationStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        return this.findAnnotatedConverter(cls);
    }

    private <T> StringConverter<T> findAnnotatedConverter(Class<T> cls) {
        Method toString = this.findToStringMethod(cls);
        if (toString == null) {
            return null;
        }
        MethodConstructorStringConverter<T> con = this.findFromStringConstructor(cls, toString);
        MethodsStringConverter<T> mth = this.findFromStringMethod(cls, toString, con == null);
        if (con == null && mth == null) {
            String string = String.valueOf(cls.getName());
            throw new IllegalStateException(string.length() != 0 ? "Class annotated with @ToString but not with @FromString: ".concat(string) : new String("Class annotated with @ToString but not with @FromString: "));
        }
        if (con != null && mth != null) {
            String string = String.valueOf(cls.getName());
            throw new IllegalStateException(string.length() != 0 ? "Both method and constructor are annotated with @FromString: ".concat(string) : new String("Both method and constructor are annotated with @FromString: "));
        }
        return con != null ? con : mth;
    }

    private Method findToStringMethod(Class<?> cls) {
        Method matched = null;
        for (Class<?> loopCls = cls; loopCls != null && matched == null; loopCls = loopCls.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = loopCls.getDeclaredMethods()) {
                ToString toString = method.getAnnotation(ToString.class);
                if (toString == null) continue;
                if (matched != null) {
                    String string = String.valueOf(cls.getName());
                    throw new IllegalStateException(string.length() != 0 ? "Two methods are annotated with @ToString: ".concat(string) : new String("Two methods are annotated with @ToString: "));
                }
                matched = method;
            }
        }
        if (matched == null) {
            for (Class<?> loopIfc : this.eliminateEnumSubclass(cls).getInterfaces()) {
                Method[] methods;
                for (Method method : methods = loopIfc.getDeclaredMethods()) {
                    ToString toString = method.getAnnotation(ToString.class);
                    if (toString == null) continue;
                    if (matched != null) {
                        String string = String.valueOf(cls.getName());
                        throw new IllegalStateException(string.length() != 0 ? "Two methods are annotated with @ToString on interfaces: ".concat(string) : new String("Two methods are annotated with @ToString on interfaces: "));
                    }
                    matched = method;
                }
            }
        }
        return matched;
    }

    private <T> MethodConstructorStringConverter<T> findFromStringConstructor(Class<T> cls, Method toString) {
        Constructor<FromString> con;
        try {
            con = cls.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                con = cls.getDeclaredConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
        FromString fromString = con.getAnnotation(FromString.class);
        if (fromString == null) {
            return null;
        }
        return new MethodConstructorStringConverter<T>(cls, toString, con);
    }

    private <T> MethodsStringConverter<T> findFromStringMethod(Class<T> cls, Method toString, boolean searchSuperclasses) {
        for (Class<T> loopCls = cls; loopCls != null; loopCls = loopCls.getSuperclass()) {
            Method fromString = this.findFromString(loopCls);
            if (fromString != null) {
                return new MethodsStringConverter<T>(cls, toString, fromString, loopCls);
            }
            if (!searchSuperclasses) break;
        }
        MethodsStringConverter<T> matched = null;
        if (searchSuperclasses) {
            for (Class<?> loopIfc : this.eliminateEnumSubclass(cls).getInterfaces()) {
                Method fromString = this.findFromString(loopIfc);
                if (fromString == null) continue;
                if (matched != null) {
                    String string = String.valueOf("Two different interfaces are annotated with @FromString or @FromStringFactory: ");
                    String string2 = String.valueOf(cls.getName());
                    throw new IllegalStateException(string2.length() != 0 ? string.concat(string2) : new String(string));
                }
                matched = new MethodsStringConverter<T>(cls, toString, fromString, loopIfc);
            }
        }
        return matched;
    }

    private Method findFromString(Class<?> cls) {
        Method[] methods = cls.getDeclaredMethods();
        Method matched = null;
        for (Method method : methods) {
            FromString fromString = method.getAnnotation(FromString.class);
            if (fromString == null) continue;
            if (matched != null) {
                String string = String.valueOf(cls.getName());
                throw new IllegalStateException(string.length() != 0 ? "Two methods are annotated with @FromString: ".concat(string) : new String("Two methods are annotated with @FromString: "));
            }
            matched = method;
        }
        FromStringFactory factory = cls.getAnnotation(FromStringFactory.class);
        if (factory != null) {
            Method[] factoryMethods;
            if (matched != null) {
                String string = String.valueOf(cls.getName());
                throw new IllegalStateException(string.length() != 0 ? "Class annotated with @FromString and @FromStringFactory: ".concat(string) : new String("Class annotated with @FromString and @FromStringFactory: "));
            }
            for (Method method : factoryMethods = factory.factory().getDeclaredMethods()) {
                FromString fromString;
                if (!cls.isAssignableFrom(method.getReturnType()) || (fromString = method.getAnnotation(FromString.class)) == null) continue;
                if (matched != null) {
                    String string = String.valueOf(factory.factory().getName());
                    throw new IllegalStateException(string.length() != 0 ? "Two methods are annotated with @FromString on the factory: ".concat(string) : new String("Two methods are annotated with @FromString on the factory: "));
                }
                matched = method;
            }
        }
        return matched;
    }

    private Class<?> eliminateEnumSubclass(Class<?> cls) {
        Class<?> sup = cls.getSuperclass();
        if (sup != null && sup.getSuperclass() == Enum.class) {
            return sup;
        }
        return cls;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

