/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.joda.convert.ReflectionStringConverter;

final class MethodsStringConverter<T>
extends ReflectionStringConverter<T> {
    private final Method fromString;
    private final Class<?> effectiveType;

    MethodsStringConverter(Class<T> cls, Method toString, Method fromString, Class<?> effectiveType) {
        super(cls, toString);
        if (!Modifier.isStatic(fromString.getModifiers())) {
            String string = String.valueOf(String.valueOf(fromString));
            throw new IllegalStateException(new StringBuilder(34 + string.length()).append("FromString method must be static: ").append(string).toString());
        }
        if (fromString.getParameterTypes().length != 1) {
            String string = String.valueOf(String.valueOf(fromString));
            throw new IllegalStateException(new StringBuilder(43 + string.length()).append("FromString method must have one parameter: ").append(string).toString());
        }
        Class<?> param = fromString.getParameterTypes()[0];
        if (param != String.class && param != CharSequence.class) {
            String string = String.valueOf(String.valueOf(fromString));
            throw new IllegalStateException(new StringBuilder(54 + string.length()).append("FromString method must take a String or CharSequence: ").append(string).toString());
        }
        if (!fromString.getReturnType().isAssignableFrom(cls) && !cls.isAssignableFrom(fromString.getReturnType())) {
            String string = String.valueOf(String.valueOf(fromString));
            throw new IllegalStateException(new StringBuilder(62 + string.length()).append("FromString method must return specified class or a supertype: ").append(string).toString());
        }
        this.fromString = fromString;
        this.effectiveType = effectiveType;
    }

    @Override
    public T convertFromString(Class<? extends T> cls, String str) {
        try {
            return cls.cast(this.fromString.invoke(null, str));
        }
        catch (IllegalAccessException ex) {
            String string = String.valueOf(String.valueOf(this.fromString));
            throw new IllegalStateException(new StringBuilder(26 + string.length()).append("Method is not accessible: ").append(string).toString());
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getMessage(), ex.getCause());
        }
    }

    @Override
    public Class<?> getEffectiveType() {
        return this.effectiveType;
    }
}

