/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.joda.convert.TypedStringConverter;

abstract class ReflectionStringConverter<T>
implements TypedStringConverter<T> {
    private final Class<T> cls;
    private final Method toString;

    ReflectionStringConverter(Class<T> cls, Method toString) {
        if (toString.getParameterTypes().length != 0) {
            String string = String.valueOf(String.valueOf(toString));
            throw new IllegalStateException(new StringBuilder(41 + string.length()).append("ToString method must have no parameters: ").append(string).toString());
        }
        if (toString.getReturnType() != String.class) {
            String string = String.valueOf(String.valueOf(toString));
            throw new IllegalStateException(new StringBuilder(38 + string.length()).append("ToString method must return a String: ").append(string).toString());
        }
        this.cls = cls;
        this.toString = toString;
    }

    @Override
    public String convertToString(T object) {
        try {
            return (String)this.toString.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            String string = String.valueOf(String.valueOf(this.toString));
            throw new IllegalStateException(new StringBuilder(26 + string.length()).append("Method is not accessible: ").append(string).toString());
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getMessage(), ex.getCause());
        }
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.cls.getSimpleName()));
        return new StringBuilder(26 + string.length()).append("RefectionStringConverter[").append(string).append("]").toString();
    }
}

