/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import org.joda.convert.StringConverter;
import org.joda.convert.TypedStringConverter;

final class TypedAdapter<T>
implements TypedStringConverter<T> {
    private final StringConverter<T> conv;
    private final Class<?> effectiveType;

    static <R> TypedStringConverter<R> adapt(Class<R> cls, StringConverter<R> converter) {
        if (converter instanceof TypedStringConverter) {
            return (TypedStringConverter)converter;
        }
        return new TypedAdapter<R>(converter, cls);
    }

    private TypedAdapter(StringConverter<T> conv, Class<?> effectiveType) {
        this.conv = conv;
        this.effectiveType = effectiveType;
    }

    @Override
    public String convertToString(T object) {
        return this.conv.convertToString(object);
    }

    @Override
    public T convertFromString(Class<? extends T> cls, String str) {
        return this.conv.convertFromString(cls, str);
    }

    @Override
    public Class<?> getEffectiveType() {
        return this.effectiveType;
    }

    public String toString() {
        String string = String.valueOf(this.conv.toString());
        return string.length() != 0 ? "TypedAdapter:".concat(string) : new String("TypedAdapter:");
    }
}

