/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.JodaTimePermission;
import org.joda.time.PeriodType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;

public class DateTimeUtils {
    private static final SystemMillisProvider SYSTEM_MILLIS_PROVIDER = new SystemMillisProvider();
    private static volatile MillisProvider cMillisProvider = SYSTEM_MILLIS_PROVIDER;
    private static volatile Map<String, DateTimeZone> cZoneNames;

    private static void put(Map<String, DateTimeZone> map, String name, String id) {
        try {
            map.put(name, DateTimeZone.forID(id));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected DateTimeUtils() {
    }

    public static final long currentTimeMillis() {
        return cMillisProvider.getMillis();
    }

    public static final void setCurrentMillisSystem() throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = SYSTEM_MILLIS_PROVIDER;
    }

    public static final void setCurrentMillisFixed(long fixedMillis) throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = new FixedMillisProvider(fixedMillis);
    }

    public static final void setCurrentMillisOffset(long offsetMillis) throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = offsetMillis == 0L ? SYSTEM_MILLIS_PROVIDER : new OffsetMillisProvider(offsetMillis);
    }

    public static final void setCurrentMillisProvider(MillisProvider millisProvider) throws SecurityException {
        if (millisProvider == null) {
            throw new IllegalArgumentException("The MillisProvider must not be null");
        }
        DateTimeUtils.checkPermission();
        cMillisProvider = millisProvider;
    }

    private static void checkPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("CurrentTime.setProvider"));
        }
    }

    public static final long getInstantMillis(ReadableInstant instant) {
        if (instant == null) {
            return DateTimeUtils.currentTimeMillis();
        }
        return instant.getMillis();
    }

    public static final Chronology getInstantChronology(ReadableInstant instant) {
        if (instant == null) {
            return ISOChronology.getInstance();
        }
        Chronology chrono = instant.getChronology();
        if (chrono == null) {
            return ISOChronology.getInstance();
        }
        return chrono;
    }

    public static final Chronology getIntervalChronology(ReadableInstant start, ReadableInstant end) {
        Chronology chrono = null;
        if (start != null) {
            chrono = start.getChronology();
        } else if (end != null) {
            chrono = end.getChronology();
        }
        if (chrono == null) {
            chrono = ISOChronology.getInstance();
        }
        return chrono;
    }

    public static final Chronology getIntervalChronology(ReadableInterval interval) {
        if (interval == null) {
            return ISOChronology.getInstance();
        }
        Chronology chrono = interval.getChronology();
        if (chrono == null) {
            return ISOChronology.getInstance();
        }
        return chrono;
    }

    public static final ReadableInterval getReadableInterval(ReadableInterval interval) {
        if (interval == null) {
            long now = DateTimeUtils.currentTimeMillis();
            interval = new Interval(now, now);
        }
        return interval;
    }

    public static final Chronology getChronology(Chronology chrono) {
        if (chrono == null) {
            return ISOChronology.getInstance();
        }
        return chrono;
    }

    public static final DateTimeZone getZone(DateTimeZone zone) {
        if (zone == null) {
            return DateTimeZone.getDefault();
        }
        return zone;
    }

    public static final PeriodType getPeriodType(PeriodType type) {
        if (type == null) {
            return PeriodType.standard();
        }
        return type;
    }

    public static final long getDurationMillis(ReadableDuration duration) {
        if (duration == null) {
            return 0L;
        }
        return duration.getMillis();
    }

    public static final boolean isContiguous(ReadablePartial partial) {
        if (partial == null) {
            throw new IllegalArgumentException("Partial must not be null");
        }
        DurationFieldType lastType = null;
        for (int i = 0; i < partial.size(); ++i) {
            DateTimeField loopField = partial.getField(i);
            if (i > 0 && loopField.getRangeDurationField().getType() != lastType) {
                return false;
            }
            lastType = loopField.getDurationField().getType();
        }
        return true;
    }

    public static final DateFormatSymbols getDateFormatSymbols(Locale locale) {
        try {
            Method method = DateFormatSymbols.class.getMethod("getInstance", Locale.class);
            return (DateFormatSymbols)method.invoke(null, locale);
        }
        catch (Exception ex) {
            return new DateFormatSymbols(locale);
        }
    }

    public static final Map<String, DateTimeZone> getDefaultTimeZoneNames() {
        return cZoneNames;
    }

    public static final void setDefaultTimeZoneNames(Map<String, DateTimeZone> names) {
        cZoneNames = Collections.unmodifiableMap(new HashMap<String, DateTimeZone>(names));
    }

    public static final double toJulianDay(long epochMillis) {
        double epochDay = (double)epochMillis / 8.64E7;
        return epochDay + 2440587.5;
    }

    public static final long toJulianDayNumber(long epochMillis) {
        return (long)Math.floor(DateTimeUtils.toJulianDay(epochMillis) + 0.5);
    }

    public static final long fromJulianDay(double julianDay) {
        double epochDay = julianDay - 2440587.5;
        return (long)(epochDay * 8.64E7);
    }

    static {
        LinkedHashMap<String, DateTimeZone> map = new LinkedHashMap<String, DateTimeZone>();
        map.put("UT", DateTimeZone.UTC);
        map.put("UTC", DateTimeZone.UTC);
        map.put("GMT", DateTimeZone.UTC);
        DateTimeUtils.put(map, "EST", "America/New_York");
        DateTimeUtils.put(map, "EDT", "America/New_York");
        DateTimeUtils.put(map, "CST", "America/Chicago");
        DateTimeUtils.put(map, "CDT", "America/Chicago");
        DateTimeUtils.put(map, "MST", "America/Denver");
        DateTimeUtils.put(map, "MDT", "America/Denver");
        DateTimeUtils.put(map, "PST", "America/Los_Angeles");
        DateTimeUtils.put(map, "PDT", "America/Los_Angeles");
        cZoneNames = Collections.unmodifiableMap(map);
    }

    static class OffsetMillisProvider
    implements MillisProvider {
        private final long iMillis;

        OffsetMillisProvider(long offsetMillis) {
            this.iMillis = offsetMillis;
        }

        @Override
        public long getMillis() {
            return System.currentTimeMillis() + this.iMillis;
        }
    }

    static class FixedMillisProvider
    implements MillisProvider {
        private final long iMillis;

        FixedMillisProvider(long fixedMillis) {
            this.iMillis = fixedMillis;
        }

        @Override
        public long getMillis() {
            return this.iMillis;
        }
    }

    static class SystemMillisProvider
    implements MillisProvider {
        SystemMillisProvider() {
        }

        @Override
        public long getMillis() {
            return System.currentTimeMillis();
        }
    }

    public static interface MillisProvider {
        public long getMillis();
    }
}

