/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BasePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public final class MonthDay
extends BasePartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 2954560699050434609L;
    private static final DateTimeFieldType[] FIELD_TYPES = new DateTimeFieldType[]{DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth()};
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendOptional(ISODateTimeFormat.localDateParser().getParser()).appendOptional(DateTimeFormat.forPattern("--MM-dd").getParser()).toFormatter();
    public static final int MONTH_OF_YEAR = 0;
    public static final int DAY_OF_MONTH = 1;

    public static MonthDay now() {
        return new MonthDay();
    }

    public static MonthDay now(DateTimeZone zone) {
        if (zone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new MonthDay(zone);
    }

    public static MonthDay now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new MonthDay(chronology);
    }

    @FromString
    public static MonthDay parse(String str) {
        return MonthDay.parse(str, PARSER);
    }

    public static MonthDay parse(String str, DateTimeFormatter formatter) {
        LocalDate date = formatter.parseLocalDate(str);
        return new MonthDay(date.getMonthOfYear(), date.getDayOfMonth());
    }

    public static MonthDay fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new MonthDay(calendar.get(2) + 1, calendar.get(5));
    }

    public static MonthDay fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new MonthDay(date.getMonth() + 1, date.getDate());
    }

    public MonthDay() {
    }

    public MonthDay(DateTimeZone zone) {
        super(ISOChronology.getInstance(zone));
    }

    public MonthDay(Chronology chronology) {
        super(chronology);
    }

    public MonthDay(long instant) {
        super(instant);
    }

    public MonthDay(long instant, Chronology chronology) {
        super(instant, chronology);
    }

    public MonthDay(Object instant) {
        super(instant, null, ISODateTimeFormat.localDateParser());
    }

    public MonthDay(Object instant, Chronology chronology) {
        super(instant, DateTimeUtils.getChronology(chronology), ISODateTimeFormat.localDateParser());
    }

    public MonthDay(int monthOfYear, int dayOfMonth) {
        this(monthOfYear, dayOfMonth, null);
    }

    public MonthDay(int monthOfYear, int dayOfMonth, Chronology chronology) {
        super(new int[]{monthOfYear, dayOfMonth}, chronology);
    }

    MonthDay(MonthDay partial, int[] values) {
        super((BasePartial)partial, values);
    }

    MonthDay(MonthDay partial, Chronology chrono) {
        super((BasePartial)partial, chrono);
    }

    private Object readResolve() {
        if (!DateTimeZone.UTC.equals(this.getChronology().getZone())) {
            return new MonthDay(this, this.getChronology().withUTC());
        }
        return this;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    protected DateTimeField getField(int index, Chronology chrono) {
        switch (index) {
            case 0: {
                return chrono.monthOfYear();
            }
            case 1: {
                return chrono.dayOfMonth();
            }
        }
        throw new IndexOutOfBoundsException(new StringBuilder(26).append("Invalid index: ").append(index).toString());
    }

    @Override
    public DateTimeFieldType getFieldType(int index) {
        return FIELD_TYPES[index];
    }

    @Override
    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public MonthDay withChronologyRetainFields(Chronology newChronology) {
        newChronology = DateTimeUtils.getChronology(newChronology);
        if ((newChronology = newChronology.withUTC()) == this.getChronology()) {
            return this;
        }
        MonthDay newMonthDay = new MonthDay(this, newChronology);
        newChronology.validate(newMonthDay, this.getValues());
        return newMonthDay;
    }

    public MonthDay withField(DateTimeFieldType fieldType, int value) {
        int index = this.indexOfSupported(fieldType);
        if (value == this.getValue(index)) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).set(this, index, newValues, value);
        return new MonthDay(this, newValues);
    }

    public MonthDay withFieldAdded(DurationFieldType fieldType, int amount) {
        int index = this.indexOfSupported(fieldType);
        if (amount == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).add(this, index, newValues, amount);
        return new MonthDay(this, newValues);
    }

    public MonthDay withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        for (int i = 0; i < period.size(); ++i) {
            DurationFieldType fieldType = period.getFieldType(i);
            int index = this.indexOf(fieldType);
            if (index < 0) continue;
            newValues = this.getField(index).add(this, index, newValues, FieldUtils.safeMultiply(period.getValue(i), scalar));
        }
        return new MonthDay(this, newValues);
    }

    public MonthDay plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public MonthDay plusMonths(int months) {
        return this.withFieldAdded(DurationFieldType.months(), months);
    }

    public MonthDay plusDays(int days) {
        return this.withFieldAdded(DurationFieldType.days(), days);
    }

    public MonthDay minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public MonthDay minusMonths(int months) {
        return this.withFieldAdded(DurationFieldType.months(), FieldUtils.safeNegate(months));
    }

    public MonthDay minusDays(int days) {
        return this.withFieldAdded(DurationFieldType.days(), FieldUtils.safeNegate(days));
    }

    public LocalDate toLocalDate(int year) {
        return new LocalDate(year, this.getMonthOfYear(), this.getDayOfMonth(), this.getChronology());
    }

    public int getMonthOfYear() {
        return this.getValue(0);
    }

    public int getDayOfMonth() {
        return this.getValue(1);
    }

    public MonthDay withMonthOfYear(int monthOfYear) {
        int[] newValues = this.getValues();
        newValues = this.getChronology().monthOfYear().set(this, 0, newValues, monthOfYear);
        return new MonthDay(this, newValues);
    }

    public MonthDay withDayOfMonth(int dayOfMonth) {
        int[] newValues = this.getValues();
        newValues = this.getChronology().dayOfMonth().set(this, 1, newValues, dayOfMonth);
        return new MonthDay(this, newValues);
    }

    public Property property(DateTimeFieldType type) {
        return new Property(this, this.indexOfSupported(type));
    }

    public Property monthOfYear() {
        return new Property(this, 0);
    }

    public Property dayOfMonth() {
        return new Property(this, 1);
    }

    @Override
    @ToString
    public String toString() {
        ArrayList<DateTimeFieldType> fields = new ArrayList<DateTimeFieldType>();
        fields.add(DateTimeFieldType.monthOfYear());
        fields.add(DateTimeFieldType.dayOfMonth());
        return ISODateTimeFormat.forFields(fields, true, true).print(this);
    }

    @Override
    public String toString(String pattern) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).print(this);
    }

    @Override
    public String toString(String pattern, Locale locale) throws IllegalArgumentException {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).withLocale(locale).print(this);
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 5727734012190224363L;
        private final MonthDay iBase;
        private final int iFieldIndex;

        Property(MonthDay partial, int fieldIndex) {
            this.iBase = partial;
            this.iFieldIndex = fieldIndex;
        }

        @Override
        public DateTimeField getField() {
            return this.iBase.getField(this.iFieldIndex);
        }

        @Override
        protected ReadablePartial getReadablePartial() {
            return this.iBase;
        }

        public MonthDay getMonthDay() {
            return this.iBase;
        }

        @Override
        public int get() {
            return this.iBase.getValue(this.iFieldIndex);
        }

        public MonthDay addToCopy(int valueToAdd) {
            int[] newValues = this.iBase.getValues();
            newValues = this.getField().add(this.iBase, this.iFieldIndex, newValues, valueToAdd);
            return new MonthDay(this.iBase, newValues);
        }

        public MonthDay addWrapFieldToCopy(int valueToAdd) {
            int[] newValues = this.iBase.getValues();
            newValues = this.getField().addWrapField(this.iBase, this.iFieldIndex, newValues, valueToAdd);
            return new MonthDay(this.iBase, newValues);
        }

        public MonthDay setCopy(int value) {
            int[] newValues = this.iBase.getValues();
            newValues = this.getField().set(this.iBase, this.iFieldIndex, newValues, value);
            return new MonthDay(this.iBase, newValues);
        }

        public MonthDay setCopy(String text, Locale locale) {
            int[] newValues = this.iBase.getValues();
            newValues = this.getField().set(this.iBase, this.iFieldIndex, newValues, text, locale);
            return new MonthDay(this.iBase, newValues);
        }

        public MonthDay setCopy(String text) {
            return this.setCopy(text, null);
        }
    }
}

