/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.LocalTime;
import org.joda.time.Minutes;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Seconds
extends BaseSingleFieldPeriod {
    public static final Seconds ZERO = new Seconds(0);
    public static final Seconds ONE = new Seconds(1);
    public static final Seconds TWO = new Seconds(2);
    public static final Seconds THREE = new Seconds(3);
    public static final Seconds MAX_VALUE = new Seconds(Integer.MAX_VALUE);
    public static final Seconds MIN_VALUE = new Seconds(Integer.MIN_VALUE);
    private static final PeriodFormatter PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.seconds());
    private static final long serialVersionUID = 87525275727380862L;

    public static Seconds seconds(int seconds) {
        switch (seconds) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Seconds(seconds);
    }

    public static Seconds secondsBetween(ReadableInstant start, ReadableInstant end) {
        int amount = BaseSingleFieldPeriod.between(start, end, DurationFieldType.seconds());
        return Seconds.seconds(amount);
    }

    public static Seconds secondsBetween(ReadablePartial start, ReadablePartial end) {
        if (start instanceof LocalTime && end instanceof LocalTime) {
            Chronology chrono = DateTimeUtils.getChronology(start.getChronology());
            int seconds = chrono.seconds().getDifference(((LocalTime)end).getLocalMillis(), ((LocalTime)start).getLocalMillis());
            return Seconds.seconds(seconds);
        }
        int amount = BaseSingleFieldPeriod.between(start, end, ZERO);
        return Seconds.seconds(amount);
    }

    public static Seconds secondsIn(ReadableInterval interval) {
        if (interval == null) {
            return ZERO;
        }
        int amount = BaseSingleFieldPeriod.between(interval.getStart(), interval.getEnd(), DurationFieldType.seconds());
        return Seconds.seconds(amount);
    }

    public static Seconds standardSecondsIn(ReadablePeriod period) {
        int amount = BaseSingleFieldPeriod.standardPeriodIn(period, 1000L);
        return Seconds.seconds(amount);
    }

    @FromString
    public static Seconds parseSeconds(String periodStr) {
        if (periodStr == null) {
            return ZERO;
        }
        Period p = PARSER.parsePeriod(periodStr);
        return Seconds.seconds(p.getSeconds());
    }

    private Seconds(int seconds) {
        super(seconds);
    }

    private Object readResolve() {
        return Seconds.seconds(this.getValue());
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.seconds();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.seconds();
    }

    public Weeks toStandardWeeks() {
        return Weeks.weeks(this.getValue() / 604800);
    }

    public Days toStandardDays() {
        return Days.days(this.getValue() / 86400);
    }

    public Hours toStandardHours() {
        return Hours.hours(this.getValue() / 3600);
    }

    public Minutes toStandardMinutes() {
        return Minutes.minutes(this.getValue() / 60);
    }

    public Duration toStandardDuration() {
        long seconds = this.getValue();
        return new Duration(seconds * 1000L);
    }

    public int getSeconds() {
        return this.getValue();
    }

    public Seconds plus(int seconds) {
        if (seconds == 0) {
            return this;
        }
        return Seconds.seconds(FieldUtils.safeAdd(this.getValue(), seconds));
    }

    public Seconds plus(Seconds seconds) {
        if (seconds == null) {
            return this;
        }
        return this.plus(seconds.getValue());
    }

    public Seconds minus(int seconds) {
        return this.plus(FieldUtils.safeNegate(seconds));
    }

    public Seconds minus(Seconds seconds) {
        if (seconds == null) {
            return this;
        }
        return this.minus(seconds.getValue());
    }

    public Seconds multipliedBy(int scalar) {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), scalar));
    }

    public Seconds dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        return Seconds.seconds(this.getValue() / divisor);
    }

    public Seconds negated() {
        return Seconds.seconds(FieldUtils.safeNegate(this.getValue()));
    }

    public boolean isGreaterThan(Seconds other) {
        if (other == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > other.getValue();
    }

    public boolean isLessThan(Seconds other) {
        if (other == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < other.getValue();
    }

    @Override
    @ToString
    public String toString() {
        String string = String.valueOf(this.getValue());
        return new StringBuilder(3 + String.valueOf(string).length()).append("PT").append(string).append("S").toString();
    }
}

