/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.chrono.BasicMonthOfYearDateTimeField;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.chrono.ZonedChronology;

public final class IslamicChronology
extends BasicChronology {
    private static final long serialVersionUID = -3663823829888L;
    public static final int AH = 1;
    private static final DateTimeField ERA_FIELD = new BasicSingleEraDateTimeField("AH");
    public static final LeapYearPatternType LEAP_YEAR_15_BASED = new LeapYearPatternType(0, 623158436);
    public static final LeapYearPatternType LEAP_YEAR_16_BASED = new LeapYearPatternType(1, 623191204);
    public static final LeapYearPatternType LEAP_YEAR_INDIAN = new LeapYearPatternType(2, 690562340);
    public static final LeapYearPatternType LEAP_YEAR_HABASH_AL_HASIB = new LeapYearPatternType(3, 0x9292925);
    private static final int MIN_YEAR = -292269337;
    private static final int MAX_YEAR = 292271022;
    private static final int MONTH_PAIR_LENGTH = 59;
    private static final int LONG_MONTH_LENGTH = 30;
    private static final int SHORT_MONTH_LENGTH = 29;
    private static final long MILLIS_PER_MONTH_PAIR = 5097600000L;
    private static final long MILLIS_PER_MONTH = 2551440384L;
    private static final long MILLIS_PER_LONG_MONTH = 2592000000L;
    private static final long MILLIS_PER_YEAR = 30617280288L;
    private static final long MILLIS_PER_SHORT_YEAR = 30585600000L;
    private static final long MILLIS_PER_LONG_YEAR = 30672000000L;
    private static final long MILLIS_YEAR_1 = -42521587200000L;
    private static final int CYCLE = 30;
    private static final long MILLIS_PER_CYCLE = 918518400000L;
    private static final ConcurrentHashMap<DateTimeZone, IslamicChronology[]> cCache = new ConcurrentHashMap();
    private static final IslamicChronology INSTANCE_UTC = IslamicChronology.getInstance(DateTimeZone.UTC);
    private final LeapYearPatternType iLeapYears;

    public static IslamicChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static IslamicChronology getInstance() {
        return IslamicChronology.getInstance(DateTimeZone.getDefault(), LEAP_YEAR_16_BASED);
    }

    public static IslamicChronology getInstance(DateTimeZone zone) {
        return IslamicChronology.getInstance(zone, LEAP_YEAR_16_BASED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IslamicChronology getInstance(DateTimeZone zone, LeapYearPatternType leapYears) {
        IslamicChronology chrono;
        IslamicChronology[] oldChronos;
        IslamicChronology[] chronos;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if ((chronos = cCache.get(zone)) == null && (oldChronos = cCache.putIfAbsent(zone, chronos = new IslamicChronology[4])) != null) {
            chronos = oldChronos;
        }
        if ((chrono = chronos[leapYears.index]) != null) return chrono;
        IslamicChronology[] islamicChronologyArray = chronos;
        synchronized (chronos) {
            chrono = chronos[leapYears.index];
            if (chrono != null) return chrono;
            if (zone == DateTimeZone.UTC) {
                chrono = new IslamicChronology(null, null, leapYears);
                DateTime lowerLimit = new DateTime(1, 1, 1, 0, 0, 0, 0, chrono);
                chrono = new IslamicChronology((Chronology)LimitChronology.getInstance(chrono, lowerLimit, null), null, leapYears);
            } else {
                chrono = IslamicChronology.getInstance(DateTimeZone.UTC, leapYears);
                chrono = new IslamicChronology((Chronology)ZonedChronology.getInstance(chrono, zone), null, leapYears);
            }
            chronos[leapYears.index] = chrono;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return chrono;
        }
    }

    IslamicChronology(Chronology base, Object param, LeapYearPatternType leapYears) {
        super(base, param, 4);
        this.iLeapYears = leapYears;
    }

    private Object readResolve() {
        Chronology base = this.getBase();
        return base == null ? IslamicChronology.getInstanceUTC() : IslamicChronology.getInstance(base.getZone());
    }

    public LeapYearPatternType getLeapYearPatternType() {
        return this.iLeapYears;
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return IslamicChronology.getInstance(zone);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IslamicChronology) {
            IslamicChronology chrono = (IslamicChronology)obj;
            return this.getLeapYearPatternType().index == chrono.getLeapYearPatternType().index && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 13 + this.getLeapYearPatternType().hashCode();
    }

    @Override
    int getYear(long instant) {
        long yearMillis;
        long millisIslamic = instant - -42521587200000L;
        long cycles = millisIslamic / 918518400000L;
        int year = (int)(cycles * 30L + 1L);
        long l = yearMillis = this.isLeapYear(year) ? 30672000000L : 30585600000L;
        for (long cycleRemainder = millisIslamic % 918518400000L; cycleRemainder >= yearMillis; cycleRemainder -= yearMillis) {
            yearMillis = this.isLeapYear(++year) ? 30672000000L : 30585600000L;
        }
        return year;
    }

    @Override
    long setYear(long instant, int year) {
        int thisYear = this.getYear(instant);
        int dayOfYear = this.getDayOfYear(instant, thisYear);
        int millisOfDay = this.getMillisOfDay(instant);
        if (dayOfYear > 354 && !this.isLeapYear(year)) {
            --dayOfYear;
        }
        instant = this.getYearMonthDayMillis(year, 1, dayOfYear);
        return instant += (long)millisOfDay;
    }

    @Override
    long getYearDifference(long minuendInstant, long subtrahendInstant) {
        int minuendYear = this.getYear(minuendInstant);
        int subtrahendYear = this.getYear(subtrahendInstant);
        long minuendRem = minuendInstant - this.getYearMillis(minuendYear);
        long subtrahendRem = subtrahendInstant - this.getYearMillis(subtrahendYear);
        int difference = minuendYear - subtrahendYear;
        if (minuendRem < subtrahendRem) {
            --difference;
        }
        return difference;
    }

    @Override
    long getTotalMillisByYearMonth(int year, int month) {
        if (--month % 2 == 1) {
            return (long)(month /= 2) * 5097600000L + 2592000000L;
        }
        return (long)(month /= 2) * 5097600000L;
    }

    @Override
    int getDayOfMonth(long millis) {
        int doy = this.getDayOfYear(millis) - 1;
        if (doy == 354) {
            return 30;
        }
        return doy % 59 % 30 + 1;
    }

    @Override
    boolean isLeapYear(int year) {
        return this.iLeapYears.isLeapYear(year);
    }

    @Override
    int getDaysInYearMax() {
        return 355;
    }

    @Override
    int getDaysInYear(int year) {
        return this.isLeapYear(year) ? 355 : 354;
    }

    @Override
    int getDaysInYearMonth(int year, int month) {
        if (month == 12 && this.isLeapYear(year)) {
            return 30;
        }
        return --month % 2 == 0 ? 30 : 29;
    }

    @Override
    int getDaysInMonthMax() {
        return 30;
    }

    @Override
    int getDaysInMonthMax(int month) {
        if (month == 12) {
            return 30;
        }
        return --month % 2 == 0 ? 30 : 29;
    }

    @Override
    int getMonthOfYear(long millis, int year) {
        int doyZeroBased = (int)((millis - this.getYearMillis(year)) / 86400000L);
        if (doyZeroBased == 354) {
            return 12;
        }
        return doyZeroBased * 2 / 59 + 1;
    }

    @Override
    long getAverageMillisPerYear() {
        return 30617280288L;
    }

    @Override
    long getAverageMillisPerYearDividedByTwo() {
        return 15308640144L;
    }

    @Override
    long getAverageMillisPerMonth() {
        return 2551440384L;
    }

    @Override
    long calculateFirstDayOfYearMillis(int year) {
        if (year > 292271022) {
            int n = year;
            throw new ArithmeticException(new StringBuilder(42).append("Year is too large: ").append(n).append(" > ").append(292271022).toString());
        }
        if (year < -292269337) {
            int n = year;
            throw new ArithmeticException(new StringBuilder(43).append("Year is too small: ").append(n).append(" < ").append(-292269337).toString());
        }
        long cycle = --year / 30;
        long millis = -42521587200000L + cycle * 918518400000L;
        int cycleRemainder = year % 30 + 1;
        for (int i = 1; i < cycleRemainder; ++i) {
            millis += this.isLeapYear(i) ? 30672000000L : 30585600000L;
        }
        return millis;
    }

    @Override
    int getMinYear() {
        return 1;
    }

    @Override
    int getMaxYear() {
        return 292271022;
    }

    @Override
    long getApproxMillisAtEpochDividedByTwo() {
        return 21260793600000L;
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.era = ERA_FIELD;
            fields.monthOfYear = new BasicMonthOfYearDateTimeField(this, 12);
            fields.months = fields.monthOfYear.getDurationField();
        }
    }

    public static class LeapYearPatternType
    implements Serializable {
        private static final long serialVersionUID = 26581275372698L;
        final byte index;
        final int pattern;

        LeapYearPatternType(int index, int pattern) {
            this.index = (byte)index;
            this.pattern = pattern;
        }

        boolean isLeapYear(int year) {
            int key = 1 << year % 30;
            return (this.pattern & key) > 0;
        }

        private Object readResolve() {
            switch (this.index) {
                case 0: {
                    return LEAP_YEAR_15_BASED;
                }
                case 1: {
                    return LEAP_YEAR_16_BASED;
                }
                case 2: {
                    return LEAP_YEAR_INDIAN;
                }
                case 3: {
                    return LEAP_YEAR_HABASH_AL_HASIB;
                }
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LeapYearPatternType) {
                return this.index == ((LeapYearPatternType)obj).index;
            }
            return false;
        }

        public int hashCode() {
            return this.index;
        }
    }
}

