/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.JodaTimePermission;
import org.joda.time.convert.CalendarConverter;
import org.joda.time.convert.Converter;
import org.joda.time.convert.ConverterSet;
import org.joda.time.convert.DateConverter;
import org.joda.time.convert.DurationConverter;
import org.joda.time.convert.InstantConverter;
import org.joda.time.convert.IntervalConverter;
import org.joda.time.convert.LongConverter;
import org.joda.time.convert.NullConverter;
import org.joda.time.convert.PartialConverter;
import org.joda.time.convert.PeriodConverter;
import org.joda.time.convert.ReadableDurationConverter;
import org.joda.time.convert.ReadableInstantConverter;
import org.joda.time.convert.ReadableIntervalConverter;
import org.joda.time.convert.ReadablePartialConverter;
import org.joda.time.convert.ReadablePeriodConverter;
import org.joda.time.convert.StringConverter;

public final class ConverterManager {
    private static ConverterManager INSTANCE;
    private ConverterSet iInstantConverters = new ConverterSet(new Converter[]{ReadableInstantConverter.INSTANCE, StringConverter.INSTANCE, CalendarConverter.INSTANCE, DateConverter.INSTANCE, LongConverter.INSTANCE, NullConverter.INSTANCE});
    private ConverterSet iPartialConverters = new ConverterSet(new Converter[]{ReadablePartialConverter.INSTANCE, ReadableInstantConverter.INSTANCE, StringConverter.INSTANCE, CalendarConverter.INSTANCE, DateConverter.INSTANCE, LongConverter.INSTANCE, NullConverter.INSTANCE});
    private ConverterSet iDurationConverters = new ConverterSet(new Converter[]{ReadableDurationConverter.INSTANCE, ReadableIntervalConverter.INSTANCE, StringConverter.INSTANCE, LongConverter.INSTANCE, NullConverter.INSTANCE});
    private ConverterSet iPeriodConverters = new ConverterSet(new Converter[]{ReadableDurationConverter.INSTANCE, ReadablePeriodConverter.INSTANCE, ReadableIntervalConverter.INSTANCE, StringConverter.INSTANCE, NullConverter.INSTANCE});
    private ConverterSet iIntervalConverters = new ConverterSet(new Converter[]{ReadableIntervalConverter.INSTANCE, StringConverter.INSTANCE, NullConverter.INSTANCE});

    public static ConverterManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConverterManager();
        }
        return INSTANCE;
    }

    protected ConverterManager() {
    }

    public InstantConverter getInstantConverter(Object object) {
        InstantConverter converter = (InstantConverter)this.iInstantConverters.select(object == null ? null : object.getClass());
        if (converter != null) {
            return converter;
        }
        String string = String.valueOf(object == null ? "null" : object.getClass().getName());
        throw new IllegalArgumentException(string.length() != 0 ? "No instant converter found for type: ".concat(string) : new String("No instant converter found for type: "));
    }

    public InstantConverter[] getInstantConverters() {
        ConverterSet set = this.iInstantConverters;
        Converter[] converters = new InstantConverter[set.size()];
        set.copyInto(converters);
        return converters;
    }

    public InstantConverter addInstantConverter(InstantConverter converter) throws SecurityException {
        this.checkAlterInstantConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new InstantConverter[1];
        this.iInstantConverters = this.iInstantConverters.add(converter, removed);
        return removed[0];
    }

    public InstantConverter removeInstantConverter(InstantConverter converter) throws SecurityException {
        this.checkAlterInstantConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new InstantConverter[1];
        this.iInstantConverters = this.iInstantConverters.remove(converter, removed);
        return removed[0];
    }

    private void checkAlterInstantConverters() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("ConverterManager.alterInstantConverters"));
        }
    }

    public PartialConverter getPartialConverter(Object object) {
        PartialConverter converter = (PartialConverter)this.iPartialConverters.select(object == null ? null : object.getClass());
        if (converter != null) {
            return converter;
        }
        String string = String.valueOf(object == null ? "null" : object.getClass().getName());
        throw new IllegalArgumentException(string.length() != 0 ? "No partial converter found for type: ".concat(string) : new String("No partial converter found for type: "));
    }

    public PartialConverter[] getPartialConverters() {
        ConverterSet set = this.iPartialConverters;
        Converter[] converters = new PartialConverter[set.size()];
        set.copyInto(converters);
        return converters;
    }

    public PartialConverter addPartialConverter(PartialConverter converter) throws SecurityException {
        this.checkAlterPartialConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new PartialConverter[1];
        this.iPartialConverters = this.iPartialConverters.add(converter, removed);
        return removed[0];
    }

    public PartialConverter removePartialConverter(PartialConverter converter) throws SecurityException {
        this.checkAlterPartialConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new PartialConverter[1];
        this.iPartialConverters = this.iPartialConverters.remove(converter, removed);
        return removed[0];
    }

    private void checkAlterPartialConverters() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("ConverterManager.alterPartialConverters"));
        }
    }

    public DurationConverter getDurationConverter(Object object) {
        DurationConverter converter = (DurationConverter)this.iDurationConverters.select(object == null ? null : object.getClass());
        if (converter != null) {
            return converter;
        }
        String string = String.valueOf(object == null ? "null" : object.getClass().getName());
        throw new IllegalArgumentException(string.length() != 0 ? "No duration converter found for type: ".concat(string) : new String("No duration converter found for type: "));
    }

    public DurationConverter[] getDurationConverters() {
        ConverterSet set = this.iDurationConverters;
        Converter[] converters = new DurationConverter[set.size()];
        set.copyInto(converters);
        return converters;
    }

    public DurationConverter addDurationConverter(DurationConverter converter) throws SecurityException {
        this.checkAlterDurationConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new DurationConverter[1];
        this.iDurationConverters = this.iDurationConverters.add(converter, removed);
        return removed[0];
    }

    public DurationConverter removeDurationConverter(DurationConverter converter) throws SecurityException {
        this.checkAlterDurationConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new DurationConverter[1];
        this.iDurationConverters = this.iDurationConverters.remove(converter, removed);
        return removed[0];
    }

    private void checkAlterDurationConverters() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("ConverterManager.alterDurationConverters"));
        }
    }

    public PeriodConverter getPeriodConverter(Object object) {
        PeriodConverter converter = (PeriodConverter)this.iPeriodConverters.select(object == null ? null : object.getClass());
        if (converter != null) {
            return converter;
        }
        String string = String.valueOf(object == null ? "null" : object.getClass().getName());
        throw new IllegalArgumentException(string.length() != 0 ? "No period converter found for type: ".concat(string) : new String("No period converter found for type: "));
    }

    public PeriodConverter[] getPeriodConverters() {
        ConverterSet set = this.iPeriodConverters;
        Converter[] converters = new PeriodConverter[set.size()];
        set.copyInto(converters);
        return converters;
    }

    public PeriodConverter addPeriodConverter(PeriodConverter converter) throws SecurityException {
        this.checkAlterPeriodConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new PeriodConverter[1];
        this.iPeriodConverters = this.iPeriodConverters.add(converter, removed);
        return removed[0];
    }

    public PeriodConverter removePeriodConverter(PeriodConverter converter) throws SecurityException {
        this.checkAlterPeriodConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new PeriodConverter[1];
        this.iPeriodConverters = this.iPeriodConverters.remove(converter, removed);
        return removed[0];
    }

    private void checkAlterPeriodConverters() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("ConverterManager.alterPeriodConverters"));
        }
    }

    public IntervalConverter getIntervalConverter(Object object) {
        IntervalConverter converter = (IntervalConverter)this.iIntervalConverters.select(object == null ? null : object.getClass());
        if (converter != null) {
            return converter;
        }
        String string = String.valueOf(object == null ? "null" : object.getClass().getName());
        throw new IllegalArgumentException(string.length() != 0 ? "No interval converter found for type: ".concat(string) : new String("No interval converter found for type: "));
    }

    public IntervalConverter[] getIntervalConverters() {
        ConverterSet set = this.iIntervalConverters;
        Converter[] converters = new IntervalConverter[set.size()];
        set.copyInto(converters);
        return converters;
    }

    public IntervalConverter addIntervalConverter(IntervalConverter converter) throws SecurityException {
        this.checkAlterIntervalConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new IntervalConverter[1];
        this.iIntervalConverters = this.iIntervalConverters.add(converter, removed);
        return removed[0];
    }

    public IntervalConverter removeIntervalConverter(IntervalConverter converter) throws SecurityException {
        this.checkAlterIntervalConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new IntervalConverter[1];
        this.iIntervalConverters = this.iIntervalConverters.remove(converter, removed);
        return removed[0];
    }

    private void checkAlterIntervalConverters() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("ConverterManager.alterIntervalConverters"));
        }
    }

    public String toString() {
        int n = this.iInstantConverters.size();
        int n2 = this.iPartialConverters.size();
        int n3 = this.iDurationConverters.size();
        int n4 = this.iPeriodConverters.size();
        int n5 = this.iIntervalConverters.size();
        return new StringBuilder(118).append("ConverterManager[").append(n).append(" instant,").append(n2).append(" partial,").append(n3).append(" duration,").append(n4).append(" period,").append(n5).append(" interval]").toString();
    }
}

