/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import org.joda.time.DateTimeZone;

public class CachedDateTimeZone
extends DateTimeZone {
    private static final long serialVersionUID = 5472298452022250685L;
    private static final int cInfoCacheMask;
    private final DateTimeZone iZone;
    private final Info[] iInfoCache = new Info[cInfoCacheMask + 1];

    public static CachedDateTimeZone forZone(DateTimeZone zone) {
        if (zone instanceof CachedDateTimeZone) {
            return (CachedDateTimeZone)zone;
        }
        return new CachedDateTimeZone(zone);
    }

    private CachedDateTimeZone(DateTimeZone zone) {
        super(zone.getID());
        this.iZone = zone;
    }

    public DateTimeZone getUncachedZone() {
        return this.iZone;
    }

    @Override
    public String getNameKey(long instant) {
        return this.getInfo(instant).getNameKey(instant);
    }

    @Override
    public int getOffset(long instant) {
        return this.getInfo(instant).getOffset(instant);
    }

    @Override
    public int getStandardOffset(long instant) {
        return this.getInfo(instant).getStandardOffset(instant);
    }

    @Override
    public boolean isFixed() {
        return this.iZone.isFixed();
    }

    @Override
    public long nextTransition(long instant) {
        return this.iZone.nextTransition(instant);
    }

    @Override
    public long previousTransition(long instant) {
        return this.iZone.previousTransition(instant);
    }

    @Override
    public int hashCode() {
        return this.iZone.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CachedDateTimeZone) {
            return this.iZone.equals(((CachedDateTimeZone)obj).iZone);
        }
        return false;
    }

    private Info getInfo(long millis) {
        Info[] cache = this.iInfoCache;
        int period = (int)(millis >> 32);
        int index = period & cInfoCacheMask;
        Info info = cache[index];
        if (info == null || (int)(info.iPeriodStart >> 32) != period) {
            cache[index] = info = this.createInfo(millis);
        }
        return info;
    }

    private Info createInfo(long millis) {
        long next;
        long periodStart = millis & 0xFFFFFFFF00000000L;
        Info info = new Info(this.iZone, periodStart);
        long end = periodStart | 0xFFFFFFFFL;
        Info chain = info;
        while ((next = this.iZone.nextTransition(periodStart)) != periodStart && next <= end) {
            periodStart = next;
            chain = chain.iNextInfo = new Info(this.iZone, periodStart);
        }
        return info;
    }

    static {
        int cacheSize;
        Integer i;
        try {
            i = Integer.getInteger("org.joda.time.tz.CachedDateTimeZone.size");
        }
        catch (SecurityException e) {
            i = null;
        }
        if (i == null) {
            cacheSize = 512;
        } else {
            cacheSize = i;
            --cacheSize;
            int shift = 0;
            while (cacheSize > 0) {
                ++shift;
                cacheSize >>= 1;
            }
            cacheSize = 1 << shift;
        }
        cInfoCacheMask = cacheSize - 1;
    }

    private static final class Info {
        public final long iPeriodStart;
        public final DateTimeZone iZoneRef;
        Info iNextInfo;
        private String iNameKey;
        private int iOffset = Integer.MIN_VALUE;
        private int iStandardOffset = Integer.MIN_VALUE;

        Info(DateTimeZone zone, long periodStart) {
            this.iPeriodStart = periodStart;
            this.iZoneRef = zone;
        }

        public String getNameKey(long millis) {
            if (this.iNextInfo == null || millis < this.iNextInfo.iPeriodStart) {
                if (this.iNameKey == null) {
                    this.iNameKey = this.iZoneRef.getNameKey(this.iPeriodStart);
                }
                return this.iNameKey;
            }
            return this.iNextInfo.getNameKey(millis);
        }

        public int getOffset(long millis) {
            if (this.iNextInfo == null || millis < this.iNextInfo.iPeriodStart) {
                if (this.iOffset == Integer.MIN_VALUE) {
                    this.iOffset = this.iZoneRef.getOffset(this.iPeriodStart);
                }
                return this.iOffset;
            }
            return this.iNextInfo.getOffset(millis);
        }

        public int getStandardOffset(long millis) {
            if (this.iNextInfo == null || millis < this.iNextInfo.iPeriodStart) {
                if (this.iStandardOffset == Integer.MIN_VALUE) {
                    this.iStandardOffset = this.iZoneRef.getStandardOffset(this.iPeriodStart);
                }
                return this.iStandardOffset;
            }
            return this.iNextInfo.getStandardOffset(millis);
        }
    }
}

