/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple.google;

import com.google.common.collect.ForwardingList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.google.JSONAware;
import org.json.simple.google.JSONObject;

public class JSONArray
extends ForwardingList<Object>
implements JSONAware {
    private final List<Object> delegate;

    public JSONArray() {
        this(new ArrayList<Object>());
    }

    public JSONArray(List<Object> delegate) {
        this.delegate = delegate;
    }

    @Override
    protected List<Object> delegate() {
        return this.delegate;
    }

    @Override
    public Object set(int index, Object element) {
        JSONObject.validate(element);
        return super.set(index, element);
    }

    @Override
    public boolean add(Object element) {
        JSONObject.validate(element);
        return super.add(element);
    }

    @Override
    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.write(sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    public void write(Appendable out) throws IOException {
        if (this.isEmpty()) {
            out.append("[]");
            return;
        }
        boolean first = true;
        out.append('[');
        for (Object value : this) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            JSONObject.appendValue(value, out);
        }
        out.append(']');
    }
}

