/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple.google;

import com.google.common.collect.ForwardingMap;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.simple.google.JSONArray;
import org.json.simple.google.JSONAware;
import org.json.simple.google.MapConstraint;
import org.json.simple.google.MapConstraints;

public class JSONObject
extends ForwardingMap<String, Object>
implements JSONAware {
    private static final MapConstraint<String, Object> CONSTRAINT = new MapConstraint<String, Object>(){

        @Override
        public void checkKeyValue(String key, Object value) {
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Map keys must be strings");
            }
            JSONObject.validate(value);
        }
    };
    private final Map<String, Object> delegate;

    public JSONObject() {
        this(new LinkedHashMap<String, Object>());
    }

    public JSONObject(Map<String, Object> delegate) {
        this.delegate = MapConstraints.constrainedMap(delegate, CONSTRAINT);
    }

    @Override
    protected Map<String, Object> delegate() {
        return this.delegate;
    }

    @Override
    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.write(sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    public void write(Appendable out) throws IOException {
        if (this.isEmpty()) {
            out.append("{}");
            return;
        }
        boolean first = true;
        out.append('{');
        for (Map.Entry entry : this.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            String key = (String)entry.getKey();
            out.append('\"');
            JSONObject.escape(key, out);
            out.append("\":");
            JSONObject.appendValue(entry.getValue(), out);
        }
        out.append('}');
    }

    static void validate(Object obj) {
        if (!(obj == null || obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof JSONObject || obj instanceof JSONAware || obj instanceof JSONArray)) {
            String string = String.valueOf(obj.getClass());
            throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length()).append("Type ").append(string).append(" is not allowed").toString());
        }
    }

    public static void appendValue(Object value, Appendable out) throws IOException {
        if (value instanceof String) {
            out.append('\"');
            JSONObject.escape((String)value, out);
            out.append('\"');
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).write(out);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).write(out);
        } else if (value instanceof JSONAware) {
            out.append(((JSONAware)value).toJSONString());
        } else if (value == null || value instanceof Number || value instanceof Boolean) {
            out.append(String.valueOf(value));
        } else {
            String string = String.valueOf(value.getClass());
            throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length()).append("Type ").append(string).append(" is not allowed").toString());
        }
    }

    static void escape(String s, Appendable out) throws IOException {
        if (s == null) {
            return;
        }
        block14: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    out.append("\\\"");
                    continue block14;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block14;
                }
                case '\b': {
                    out.append("\\b");
                    continue block14;
                }
                case '\f': {
                    out.append("\\f");
                    continue block14;
                }
                case '\n': {
                    out.append("\\n");
                    continue block14;
                }
                case '\r': {
                    out.append("\\r");
                    continue block14;
                }
                case '\t': {
                    out.append("\\t");
                    continue block14;
                }
                case '/': {
                    out.append("\\/");
                    continue block14;
                }
                case '<': {
                    out.append("\\u003C");
                    continue block14;
                }
                case '\u0085': {
                    out.append("\\u0085");
                    continue block14;
                }
                case '\u2028': {
                    out.append("\\u2028");
                    continue block14;
                }
                case '\u2029': {
                    out.append("\\u2029");
                    continue block14;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        out.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            out.append('0');
                        }
                        out.append(ss.toUpperCase());
                        continue block14;
                    }
                    out.append(ch);
                }
            }
        }
    }
}

