/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple.google.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import org.json.simple.google.JSONArray;
import org.json.simple.google.JSONObject;
import org.json.simple.google.parser.Yylex;
import org.json.simple.google.parser.Yytoken;

public class JSONParser {
    public static final int S_INIT = 0;
    public static final int S_IN_FINISHED_VALUE = 1;
    public static final int S_IN_OBJECT = 2;
    public static final int S_IN_ARRAY = 3;
    public static final int S_PASSED_PAIR_KEY = 4;
    public static final int S_IN_ERROR = -1;

    private int peekStatus(Stack<Integer> statusStack) {
        if (statusStack.size() == 0) {
            return -1;
        }
        Integer status = statusStack.peek();
        return status;
    }

    public Object parse(Reader in) throws IOException {
        return this.parse(in, ParseNumbers.NO_FALLBACK);
    }

    public Object parse(Reader in, ParseNumbers parseNumbers) throws IOException {
        Stack<Integer> statusStack = new Stack<Integer>();
        Stack<Object> valueStack = new Stack<Object>();
        Yylex lexer = new Yylex(in);
        lexer.setParseNumbers(parseNumbers);
        Yytoken token = null;
        int status = 0;
        do {
            if ((token = lexer.yylex()) == null) {
                token = Yytoken.EOF;
            }
            block0 : switch (status) {
                case 0: {
                    switch (token.type) {
                        case 0: {
                            status = 1;
                            statusStack.push(status);
                            valueStack.push(token.value);
                            break block0;
                        }
                        case 1: {
                            status = 2;
                            statusStack.push(status);
                            valueStack.push(new JSONObject());
                            break block0;
                        }
                        case 3: {
                            status = 3;
                            statusStack.push(status);
                            valueStack.push(new JSONArray());
                            break block0;
                        }
                    }
                    status = -1;
                    break;
                }
                case 1: {
                    if (token.type == -1) {
                        return valueStack.pop();
                    }
                    return null;
                }
                case 2: {
                    String key;
                    switch (token.type) {
                        case 5: {
                            break block0;
                        }
                        case 0: {
                            if (token.value instanceof String) {
                                key = (String)token.value;
                                valueStack.push(key);
                                status = 4;
                                statusStack.push(status);
                                break block0;
                            }
                            status = -1;
                            break block0;
                        }
                        case 2: {
                            if (valueStack.size() > 1) {
                                statusStack.pop();
                                valueStack.pop();
                                status = this.peekStatus(statusStack);
                                break block0;
                            }
                            status = 1;
                            break block0;
                        }
                    }
                    status = -1;
                    break;
                }
                case 4: {
                    JSONArray newArray;
                    String key;
                    switch (token.type) {
                        case 6: {
                            break block0;
                        }
                        case 0: {
                            statusStack.pop();
                            key = (String)valueStack.pop();
                            JSONObject parent = (JSONObject)valueStack.peek();
                            parent.put(key, token.value);
                            status = this.peekStatus(statusStack);
                            break block0;
                        }
                        case 3: {
                            statusStack.pop();
                            key = (String)valueStack.pop();
                            JSONObject parent = (JSONObject)valueStack.peek();
                            newArray = new JSONArray();
                            parent.put(key, newArray);
                            status = 3;
                            statusStack.push(status);
                            valueStack.push(newArray);
                            break block0;
                        }
                        case 1: {
                            statusStack.pop();
                            key = (String)valueStack.pop();
                            JSONObject parent = (JSONObject)valueStack.peek();
                            JSONObject newObject = new JSONObject();
                            parent.put(key, newObject);
                            status = 2;
                            statusStack.push(status);
                            valueStack.push(newObject);
                            break block0;
                        }
                    }
                    status = -1;
                    break;
                }
                case 3: {
                    JSONArray newArray;
                    switch (token.type) {
                        case 5: {
                            break block0;
                        }
                        case 0: {
                            JSONArray val = (JSONArray)valueStack.peek();
                            val.add(token.value);
                            break block0;
                        }
                        case 4: {
                            if (valueStack.size() > 1) {
                                statusStack.pop();
                                valueStack.pop();
                                status = this.peekStatus(statusStack);
                                break block0;
                            }
                            status = 1;
                            break block0;
                        }
                        case 1: {
                            JSONArray val = (JSONArray)valueStack.peek();
                            JSONObject newObject = new JSONObject();
                            val.add(newObject);
                            status = 2;
                            statusStack.push(status);
                            valueStack.push(newObject);
                            break block0;
                        }
                        case 3: {
                            JSONArray val = (JSONArray)valueStack.peek();
                            newArray = new JSONArray();
                            val.add(newArray);
                            status = 3;
                            statusStack.push(status);
                            valueStack.push(newArray);
                            break block0;
                        }
                    }
                    status = -1;
                    break;
                }
                case -1: {
                    return null;
                }
            }
            if (status != -1) continue;
            return null;
        } while (token.type != -1);
        return null;
    }

    private static final class Stack<E> {
        final Deque<Object> delegate = new ArrayDeque<Object>();

        private Stack() {
        }

        void push(@Nullable E element) {
            this.delegate.push(element != null ? element : Sentinel.NULL);
        }

        E pop() {
            return this.toNull(this.delegate.pop());
        }

        E peek() {
            return this.toNull(this.delegate.getFirst());
        }

        int size() {
            return this.delegate.size();
        }

        private E toNull(Object value) {
            return (E)(value != Sentinel.NULL ? value : null);
        }

        static enum Sentinel {
            NULL;

        }
    }

    public static enum ParseNumbers {
        NO_FALLBACK,
        WITH_BIG_NUMBER_FALLBACK;

    }
}

