/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple.google.parser;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import org.json.simple.google.parser.JSONParser;
import org.json.simple.google.parser.Yytoken;

class Yylex {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int STRING_BEGIN = 2;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1};
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0007\u0001\u0011\u0001\u0012\u0001\u0012\u0001\u0011\u0012\u0000\u0001\u0007\u0001\u0000\u0001\t\b\u0000\u0001\u0006\u0001\u001b\u0001\u0002\u0001\u0004\u0001\n\n\u0003\u0001\u001c\u0006\u0000\u0004\u0001\u0001\u0005\u0001\u0001\u0014\u0000\u0001\u0019\u0001\b\u0001\u001a\u0003\u0000\u0001\u0014\u0001\u000b\u0002\u0001\u0001\u0013\u0001\f\u0005\u0000\u0001\u0015\u0001\u0000\u0001\r\u0003\u0000\u0001\u000e\u0001\u0016\u0001\u000f\u0001\u0010\u0005\u0000\u0001\u0017\u0001\u0000\u0001\u0018\u0007\u0000\u0001\u0012\u1fa2\u0000\u0001\u0012\u0001\u0012\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000";
    private static final char[] ZZ_CMAP = Yylex.zzUnpackCMap("\t\u0000\u0001\u0007\u0001\u0011\u0001\u0012\u0001\u0012\u0001\u0011\u0012\u0000\u0001\u0007\u0001\u0000\u0001\t\b\u0000\u0001\u0006\u0001\u001b\u0001\u0002\u0001\u0004\u0001\n\n\u0003\u0001\u001c\u0006\u0000\u0004\u0001\u0001\u0005\u0001\u0001\u0014\u0000\u0001\u0019\u0001\b\u0001\u001a\u0003\u0000\u0001\u0014\u0001\u000b\u0002\u0001\u0001\u0013\u0001\f\u0005\u0000\u0001\u0015\u0001\u0000\u0001\r\u0003\u0000\u0001\u000e\u0001\u0016\u0001\u000f\u0001\u0010\u0005\u0000\u0001\u0017\u0001\u0000\u0001\u0018\u0007\u0000\u0001\u0012\u1fa2\u0000\u0001\u0012\u0001\u0012\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000");
    private static final int[] ZZ_ACTION = Yylex.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0002\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0003\u0001\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0002\u000b\u0001\f\u0005\u0000\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0005\u0000\u0001\u0016\u0001\u0017\u0001\u0000\u0001\u0018\u0001\u0000\u0001\u0019";
    private static final int[] ZZ_ROWMAP = Yylex.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u001d\u0000:\u0000W\u0000t\u0000:\u0000:\u0000\u0091\u0000\u00ae\u0000\u00cb\u0000:\u0000:\u0000:\u0000:\u0000:\u0000:\u0000:\u0000\u00e8\u0000:\u0000\u0105\u0000\u0122\u0000\u013f\u0000\u015c\u0000\u0179\u0000:\u0000:\u0000:\u0000:\u0000:\u0000:\u0000:\u0000:\u0000\u0196\u0000\u01b3\u0000\u01d0\u0000\u01d0\u0000\u01ed\u0000\u020a\u0000\u0227\u0000\u0244\u0000\u0261\u0000:\u0000:\u0000\u027e\u0000:\u0000\u029b\u0000:";
    private static final int[] ZZ_TRANS = Yylex.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0002\u0003\u0001\u0004\u0001\u0005\u0003\u0003\u0001\u0006\u0001\u0003\u0001\u0007\u0002\u0003\u0001\b\u0001\t\u0001\u0003\u0001\n\u0001\u0003\u0001\u0006\u0005\u0003\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\b\u0011\u0001\u0012\u0001\u0013\u0007\u0011\u0002\u0003\n\u0011 \u0000\u0001\u0005\u001c\u0000\u0001\u0005\u0001\u0014\u0001\u0015\r\u0000\u0001\u0015\u001d\u0000\u0001\u0016\u0018\u0000\u0001\u0017\u001a\u0000\u0001\u0018\u0016\u0000\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001!\u000f\u0000\u0001\"\u001b\u0000\u0001#\u0001$\u0002\u0000\u0001#+\u0000\u0001%\u001c\u0000\u0001&\u0017\u0000\u0001'\r\u0000\u0001(\u0001\u0000\u0001(\u0001\u0000\u0001(\u0005\u0000\u0002(\u0006\u0000\u0002(\u000b\u0000\u0001\"\u0001\u0000\u0001\u0015\r\u0000\u0001\u0015\f\u0000\u0001$/\u0000\u0001)\u001b\u0000\u0001*\u001a\u0000\u0001+\n\u0000\u0001,\u0001\u0000\u0001,\u0001\u0000\u0001,\u0005\u0000\u0002,\u0006\u0000\u0002,\u001b\u0000\u0001-\n\u0000\u0001.\u0001\u0000\u0001.\u0001\u0000\u0001.\u0005\u0000\u0002.\u0006\u0000\u0002.\t\u0000\u0001/\u0001\u0000\u0001/\u0001\u0000\u0001/\u0005\u0000\u0002/\u0006\u0000\u0002/\b\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = Yylex.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0001\t\u0002\u0001\u0002\t\u0003\u0001\u0007\t\u0001\u0001\u0001\t\u0005\u0000\b\t\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0005\u0000\u0002\t\u0001\u0000\u0001\t\u0001\u0000\u0001\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private int zzFinalHighSurrogate = 0;
    private StringBuilder sb = new StringBuilder();
    private JSONParser.ParseNumbers parseNumbers = JSONParser.ParseNumbers.NO_FALLBACK;

    private static int[] zzUnpackAction() {
        int[] result = new int[47];
        int offset = 0;
        offset = Yylex.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[47];
        int offset = 0;
        offset = Yylex.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[696];
        int offset = 0;
        offset = Yylex.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[47];
        int offset = 0;
        offset = Yylex.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public void setParseNumbers(JSONParser.ParseNumbers parseNumbers) {
        this.parseNumbers = Preconditions.checkNotNull(parseNumbers);
    }

    Yylex(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[0x110000];
        int i = 0;
        int j = 0;
        while (i < 134) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] newBuffer = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples for workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (numRead == requested && Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                --this.zzEndRead;
                this.zzFinalHighSurrogate = 1;
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.zzFinalHighSurrogate = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public Yytoken yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block51: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    String zzNext = this.yytext();
                    throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(zzNext).length()).append("Illegal character <").append(zzNext).append(">").toString());
                }
                case 26: {
                    continue block51;
                }
                case 2: {
                    String text = this.yytext();
                    if (this.parseNumbers == JSONParser.ParseNumbers.WITH_BIG_NUMBER_FALLBACK) {
                        Number val = Longs.tryParse(text);
                        if (val == null) {
                            val = new BigInteger(text);
                        }
                        return new Yytoken(val);
                    }
                    return new Yytoken(Long.valueOf(text));
                }
                case 27: {
                    continue block51;
                }
                case 3: 
                case 28: {
                    continue block51;
                }
                case 4: {
                    this.yybegin(2);
                }
                case 29: {
                    continue block51;
                }
                case 5: {
                    return Yytoken.LEFT_BRACE;
                }
                case 30: {
                    continue block51;
                }
                case 6: {
                    return Yytoken.RIGHT_BRACE;
                }
                case 31: {
                    continue block51;
                }
                case 7: {
                    return Yytoken.LEFT_SQUARE;
                }
                case 32: {
                    continue block51;
                }
                case 8: {
                    return Yytoken.RIGHT_SQUARE;
                }
                case 33: {
                    continue block51;
                }
                case 9: {
                    return Yytoken.COMMA;
                }
                case 34: {
                    continue block51;
                }
                case 10: {
                    return Yytoken.COLON;
                }
                case 35: {
                    continue block51;
                }
                case 11: {
                    this.sb.append(this.yytext());
                }
                case 36: {
                    continue block51;
                }
                case 12: {
                    this.yybegin(0);
                    String value = this.sb.toString();
                    this.sb = new StringBuilder();
                    return new Yytoken(value);
                }
                case 37: {
                    continue block51;
                }
                case 13: {
                    this.sb.append('\\');
                }
                case 38: {
                    continue block51;
                }
                case 14: {
                    this.sb.append('\"');
                }
                case 39: {
                    continue block51;
                }
                case 15: {
                    this.sb.append('/');
                }
                case 40: {
                    continue block51;
                }
                case 16: {
                    this.sb.append('\b');
                }
                case 41: {
                    continue block51;
                }
                case 17: {
                    this.sb.append('\f');
                }
                case 42: {
                    continue block51;
                }
                case 18: {
                    this.sb.append('\n');
                }
                case 43: {
                    continue block51;
                }
                case 19: {
                    this.sb.append('\r');
                }
                case 44: {
                    continue block51;
                }
                case 20: {
                    this.sb.append('\t');
                }
                case 45: {
                    continue block51;
                }
                case 21: {
                    return new Yytoken(Double.valueOf(this.yytext()));
                }
                case 46: {
                    continue block51;
                }
                case 22: {
                    return Yytoken.NULL;
                }
                case 47: {
                    continue block51;
                }
                case 23: {
                    return Yytoken.TRUE;
                }
                case 48: {
                    continue block51;
                }
                case 24: {
                    return Yytoken.FALSE;
                }
                case 49: {
                    continue block51;
                }
                case 25: {
                    int ch = Integer.parseInt(this.yytext().substring(2), 16);
                    this.sb.append((char)ch);
                }
                case 50: {
                    continue block51;
                }
            }
            this.zzScanError(1);
        }
    }
}

