/*
 * Decompiled with CFR 0.152.
 */
package com.mythx.wrapper;

import com.mythx.wrapper.LauncherSplash;
import com.mythx.wrapper.PropertiesReader;
import com.mythx.wrapper.config.Config;
import com.mythx.wrapper.controller.ErrorController;
import com.mythx.wrapper.handler.GlobalExceptionHandler;
import com.mythx.wrapper.service.RunJarService;
import com.mythx.wrapper.service.UpdateService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launch {
    private static final Logger log = LoggerFactory.getLogger(Launch.class);
    private static final String BASE_DIR = System.getProperty("user.home") + File.separator + ".mythx" + File.separator;
    private static LauncherSplash launcherSplash;

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new GlobalExceptionHandler());
        Launch.createLogsDirectory();
        Config.get().detectBetaMode();
        log.info("Beta mode: {}", (Object)Config.get().isBetaMode());
        PropertiesReader.loadProperties();
        launcherSplash = new LauncherSplash();
        launcherSplash.start();
        try {
            UpdateService updateService = new UpdateService();
            updateService.init();
            if (Config.get().getLocalVersion() == null || Config.get().getLocalVersion().getFilename() == null) {
                throw new RuntimeException("Failed to download launcher. Please check your internet connection and try again.");
            }
            RunJarService.runJar(Config.get().getLocalVersion().getFilename() + ".jar");
        }
        catch (Exception ex) {
            log.error("Failed to start launcher", ex);
            ErrorController.sendErrorAsync("unknown", ex);
            launcherSplash.setProgressText("Error: Failed to start. Check logs.");
        }
    }

    private static void createLogsDirectory() {
        File launcherLogsDir;
        File logsDir = new File(BASE_DIR + "logs" + File.separator + "wrapper");
        if (!logsDir.exists()) {
            logsDir.mkdirs();
        }
        if (!(launcherLogsDir = new File(BASE_DIR + "logs" + File.separator + "launcher")).exists()) {
            launcherLogsDir.mkdirs();
        }
    }

    public static LauncherSplash getSplash() {
        return launcherSplash;
    }
}

